/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import nl.nn.adapterframework.management.bus.BusAction;
import nl.nn.adapterframework.management.bus.BusTopic;
import nl.nn.adapterframework.management.web.FrankApiBase;
import nl.nn.adapterframework.util.HttpUtils;
import nl.nn.adapterframework.util.JacksonUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;

public class RequestMessageBuilder {
    private Map<String, Object> customHeaders = new HashMap<String, Object>();
    private final FrankApiBase base;
    private final BusTopic topic;
    private final BusAction action;
    private Object payload = "NONE";
    private static final Logger SEC_LOG = LogManager.getLogger((String)"SEC");

    public RequestMessageBuilder(FrankApiBase base, BusTopic topic) {
        this(base, topic, null);
    }

    public RequestMessageBuilder(FrankApiBase base, BusTopic topic, BusAction action) {
        this.base = base;
        this.topic = topic;
        this.action = action;
    }

    public RequestMessageBuilder addHeader(String key, String value) {
        this.addCustomHeader(key, value);
        return this;
    }

    public RequestMessageBuilder addHeader(String key, Integer value) {
        this.addCustomHeader(key, value);
        return this;
    }

    public RequestMessageBuilder addHeader(String key, Boolean value) {
        this.addCustomHeader(key, value);
        return this;
    }

    private void addCustomHeader(String key, Object value) {
        if ("topic".equals(key)) {
            throw new IllegalStateException("unable to override topic header");
        }
        this.customHeaders.put(key, value);
    }

    public RequestMessageBuilder setJsonPayload(Object payload) {
        this.payload = JacksonUtils.convertToJson((Object)payload);
        return this;
    }

    public RequestMessageBuilder setPayload(InputStream payload) {
        this.payload = payload;
        return this;
    }

    public RequestMessageBuilder setPayload(String payload) {
        this.payload = payload;
        return this;
    }

    public static RequestMessageBuilder create(FrankApiBase base, BusTopic topic) {
        return new RequestMessageBuilder(base, topic);
    }

    public static RequestMessageBuilder create(FrankApiBase base, BusTopic topic, BusAction action) {
        return new RequestMessageBuilder(base, topic, action);
    }

    public Message<?> build() {
        if (SEC_LOG.isInfoEnabled()) {
            String method = this.base.getServletRequest().getMethod();
            String issuedBy = this.sanitizeForLog(HttpUtils.getCommandIssuedBy((HttpServletRequest)this.base.getServletRequest()));
            if (method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("OPTIONS")) {
                SEC_LOG.debug("created bus request from URI [{}:{}] issued by{}", (Object)method, (Object)this.base.getUriInfo().getRequestUri(), (Object)issuedBy);
            } else {
                String headers = this.customHeaders.entrySet().stream().map(this::mapHeaderForLog).collect(Collectors.joining(", "));
                SEC_LOG.info("created bus request from URI [{}:{}] issued by{} with headers [{}] payload [{}]", (Object)method, (Object)this.base.getUriInfo().getRequestUri(), (Object)issuedBy, (Object)headers, this.payload);
            }
        }
        DefaultMessageBuilderFactory factory = (DefaultMessageBuilderFactory)this.base.getApplicationContext().getBean("messageBuilderFactory", DefaultMessageBuilderFactory.class);
        MessageBuilder builder = factory.withPayload(this.payload);
        builder.setHeader("topic", (Object)this.topic.name());
        if (this.action != null) {
            builder.setHeader("action", (Object)this.action.name());
        }
        for (Map.Entry<String, Object> customHeader : this.customHeaders.entrySet()) {
            String key = "meta-" + customHeader.getKey();
            builder.setHeader(key, customHeader.getValue());
        }
        return builder.build();
    }

    private String mapHeaderForLog(Map.Entry<String, Object> entry) {
        StringBuilder builder = new StringBuilder(entry.getKey());
        builder.append("=");
        Object value = entry.getValue();
        builder.append(value instanceof String ? this.sanitizeForLog((String)value) : value);
        return builder.toString();
    }

    private String sanitizeForLog(String value) {
        return value.replace("\b\n\t\f\r", "");
    }

    public BusTopic getTopic() {
        return this.topic;
    }

    public BusAction getAction() {
        return this.action;
    }
}

