/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import nl.nn.adapterframework.management.web.FrankApiBase;
import nl.nn.adapterframework.management.web.Relation;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.MethodDispatcher;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;

@Path(value="/")
public class Init
extends FrankApiBase {
    private String getHATEOASImplementation() {
        return this.getProperty("iaf-api.hateoasImplementation", "default");
    }

    private boolean isMonitoringEnabled() {
        return this.getProperty("monitoring.enabled", false);
    }

    @GET
    @PermitAll
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response getAllResources(@QueryParam(value="allowedRoles") boolean displayAllowedRoles) {
        ArrayList JSONresources = new ArrayList();
        HashMap<String, Cloneable> HALresources = new HashMap<String, Cloneable>();
        HashMap<String, Cloneable> resources = new HashMap<String, Cloneable>(1);
        StringBuffer requestPath = this.getServletRequest().getRequestURL();
        if (requestPath.substring(requestPath.length() - 1).equals("/")) {
            requestPath.setLength(requestPath.length() - 1);
        }
        for (ClassResourceInfo cri : this.getJAXRSService().getClassResourceInfo()) {
            MethodDispatcher methods = cri.getMethodDispatcher();
            for (OperationResourceInfo operation : methods.getOperationResourceInfos()) {
                RolesAllowed rolesAllowed;
                Method method = operation.getMethodToInvoke();
                String relation = null;
                if (method.getDeclaringClass() == this.getClass() || method.getDeclaringClass().getName().endsWith("ShowMonitors") && !this.isMonitoringEnabled()) continue;
                boolean deprecated = method.getAnnotation(Deprecated.class) != null;
                HashMap<String, Object> resource = new HashMap<String, Object>(4);
                if (deprecated) {
                    if (!this.allowDeprecatedEndpoints()) continue;
                    resource.put("deprecated", true);
                }
                if (method.isAnnotationPresent(GET.class)) {
                    resource.put("type", "GET");
                } else if (method.isAnnotationPresent(POST.class)) {
                    resource.put("type", "POST");
                } else if (method.isAnnotationPresent(PUT.class)) {
                    resource.put("type", "PUT");
                } else if (method.isAnnotationPresent(DELETE.class)) {
                    resource.put("type", "DELETE");
                }
                Path path = method.getAnnotation(Path.class);
                if (path != null) {
                    String p = path.value();
                    if (!p.startsWith("/")) {
                        p = "/" + p;
                    }
                    resource.put("href", requestPath + p);
                }
                if ((rolesAllowed = method.getAnnotation(RolesAllowed.class)) != null && displayAllowedRoles) {
                    resource.put("allowed", rolesAllowed.value());
                }
                if ("hal".equalsIgnoreCase(this.getHATEOASImplementation())) {
                    if (method.isAnnotationPresent(Relation.class)) {
                        relation = method.getAnnotation(Relation.class).value();
                    }
                    if (relation == null) continue;
                    if (HALresources.containsKey(relation)) {
                        Object prevRelation = HALresources.get(relation);
                        ArrayList<Object> tmpList = null;
                        if (prevRelation instanceof List) {
                            tmpList = (ArrayList<Object>)prevRelation;
                        } else {
                            tmpList = new ArrayList<Object>();
                            tmpList.add(prevRelation);
                        }
                        tmpList.add(resource);
                        HALresources.put(relation, tmpList);
                        continue;
                    }
                    HALresources.put(relation, resource);
                    continue;
                }
                if (method.isAnnotationPresent(Relation.class)) {
                    resource.put("rel", method.getAnnotation(Relation.class).value());
                }
                JSONresources.add(resource);
            }
        }
        if ("hal".equalsIgnoreCase(this.getHATEOASImplementation())) {
            resources.put("_links", HALresources);
        } else {
            resources.put("links", JSONresources);
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity(resources).build();
    }
}

