/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.security.Principal;
import javax.annotation.Nonnull;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import nl.nn.adapterframework.management.bus.OutboundGateway;
import nl.nn.adapterframework.management.web.ApiException;
import nl.nn.adapterframework.management.web.RequestMessageBuilder;
import nl.nn.adapterframework.util.ResponseUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.spring.JAXRSServerFactoryBeanDefinitionParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.messaging.Message;

public abstract class FrankApiBase
implements ApplicationContextAware,
InitializingBean {
    @Context
    protected ServletConfig servletConfig;
    @Context
    protected SecurityContext securityContext;
    @Context
    protected HttpServletRequest servletRequest;
    private ApplicationContext applicationContext;
    @Context
    protected UriInfo uriInfo;
    @Context
    private Request rsRequest;
    private Environment environment;
    private JAXRSServiceFactoryBean serviceFactory = null;
    protected Logger log = LogManager.getLogger((Object)this);

    protected final OutboundGateway getGateway() {
        return (OutboundGateway)this.getApplicationContext().getBean("outboundGateway", OutboundGateway.class);
    }

    @Nonnull
    protected Message<?> sendSyncMessage(RequestMessageBuilder input) {
        Message message = this.getGateway().sendSyncMessage(input.build());
        if (message == null) {
            StringBuilder errorMessage = new StringBuilder("did not receive a reply while sending message to topic [" + input.getTopic() + "]");
            if (input.getAction() != null) {
                errorMessage.append(" with action [");
                errorMessage.append(input.getAction());
                errorMessage.append("]");
            }
            throw new ApiException(errorMessage.toString());
        }
        return message;
    }

    public Response callSyncGateway(RequestMessageBuilder input) throws ApiException {
        return this.callSyncGateway(input, false);
    }

    public Response callSyncGateway(RequestMessageBuilder input, boolean evaluateEtag) throws ApiException {
        Response.ResponseBuilder builder;
        Message<?> response = this.sendSyncMessage(input);
        EntityTag eTag = null;
        if (evaluateEtag) {
            eTag = ResponseUtils.generateETagHeaderValue(response);
        }
        if (eTag != null && (builder = this.rsRequest.evaluatePreconditions(eTag)) != null) {
            return builder.tag(eTag).build();
        }
        return ResponseUtils.convertToJaxRsResponse(response).tag(eTag).build();
    }

    public Response callAsyncGateway(RequestMessageBuilder input) {
        OutboundGateway gateway = this.getGateway();
        gateway.sendAsyncMessage(input.build());
        return Response.ok().build();
    }

    public final void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public final void afterPropertiesSet() throws Exception {
        JAXRSServerFactoryBeanDefinitionParser.SpringJAXRSServerFactoryBean server = (JAXRSServerFactoryBeanDefinitionParser.SpringJAXRSServerFactoryBean)this.applicationContext.getBean("JAXRS-IAF-API");
        this.serviceFactory = server.getServiceFactory();
        this.environment = this.applicationContext.getEnvironment();
    }

    protected <T> T getProperty(String key, T defaultValue) {
        return (T)this.environment.getProperty(key, defaultValue.getClass(), defaultValue);
    }

    protected final boolean allowDeprecatedEndpoints() {
        return this.getProperty("iaf-api.allowDeprecated", false);
    }

    protected JAXRSServiceFactoryBean getJAXRSService() {
        return this.serviceFactory;
    }

    protected String getUserPrincipalName() {
        Principal principal = this.securityContext.getUserPrincipal();
        if (principal != null && StringUtils.isNotEmpty((CharSequence)principal.getName())) {
            return principal.getName();
        }
        return null;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public Environment getEnvironment() {
        return this.environment;
    }
}

