/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import nl.nn.adapterframework.management.bus.BusAction;
import nl.nn.adapterframework.management.bus.BusMessageUtils;
import nl.nn.adapterframework.management.bus.BusTopic;
import nl.nn.adapterframework.management.web.ApiException;
import nl.nn.adapterframework.management.web.FrankApiBase;
import nl.nn.adapterframework.management.web.Relation;
import nl.nn.adapterframework.management.web.RequestMessageBuilder;
import nl.nn.adapterframework.management.web.TransactionalStorage;
import nl.nn.adapterframework.util.HttpUtils;
import nl.nn.adapterframework.util.RequestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.springframework.messaging.Message;

@Path(value="/")
public class CompatiblityTransactionalStorage
extends FrankApiBase {
    @GET
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/adapters/{adapterName}/{storageSource}/{storageSourceName}/stores/{processState}/messages/{messageId}")
    @Produces(value={"application/json"})
    @Deprecated
    public Response browseMessageOld(@PathParam(value="adapterName") String adapterName, @PathParam(value="storageSource") TransactionalStorage.StorageSource storageSource, @PathParam(value="storageSourceName") String storageSourceName, @PathParam(value="processState") String processState, @PathParam(value="messageId") String messageId, @QueryParam(value="configuration") String configuration) {
        String config = StringUtils.isNotEmpty((CharSequence)configuration) ? configuration : null;
        messageId = HttpUtils.urlDecode((String)messageId);
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.MESSAGE_BROWSER, BusAction.GET);
        builder.addHeader("configuration", config);
        builder.addHeader("adapter", adapterName);
        if (storageSource == TransactionalStorage.StorageSource.PIPES) {
            builder.addHeader("pipe", storageSourceName);
        } else {
            builder.addHeader("receiver", storageSourceName);
            builder.addHeader("processState", processState);
        }
        builder.addHeader("messageId", messageId);
        return this.callSyncGateway(builder);
    }

    @GET
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/adapters/{adapterName}/{storageSource}/{storageSourceName}/stores/{processState}/messages/{messageId}/download")
    @Produces(value={"application/octet-stream"})
    @Deprecated
    public Response downloadMessageOld(@PathParam(value="adapterName") String adapterName, @PathParam(value="storageSource") TransactionalStorage.StorageSource storageSource, @PathParam(value="storageSourceName") String storageSourceName, @PathParam(value="processState") String processState, @PathParam(value="messageId") String messageId, @QueryParam(value="configuration") String configuration) {
        String config = StringUtils.isNotEmpty((CharSequence)configuration) ? configuration : null;
        messageId = HttpUtils.urlDecode((String)messageId);
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.MESSAGE_BROWSER, BusAction.DOWNLOAD);
        builder.addHeader("configuration", config);
        builder.addHeader("adapter", adapterName);
        if (storageSource == TransactionalStorage.StorageSource.PIPES) {
            builder.addHeader("pipe", storageSourceName);
        } else {
            builder.addHeader("receiver", storageSourceName);
            builder.addHeader("processState", processState);
        }
        builder.addHeader("messageId", messageId);
        return this.callSyncGateway(builder);
    }

    @POST
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/adapters/{adapterName}/{storageSource}/{storageSourceName}/stores/{processState}/messages/download")
    @Produces(value={"application/octet-stream"})
    @Deprecated
    public Response downloadMessagesOld(@PathParam(value="adapterName") String adapterName, @PathParam(value="storageSource") TransactionalStorage.StorageSource storageSource, @PathParam(value="storageSourceName") String storageSourceName, @PathParam(value="processState") String processState, @QueryParam(value="configuration") String configuration, MultipartBody input) {
        String config = StringUtils.isNotEmpty((CharSequence)configuration) ? configuration : null;
        final RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.MESSAGE_BROWSER, BusAction.DOWNLOAD);
        builder.addHeader("configuration", config);
        builder.addHeader("adapter", adapterName);
        if (storageSource == TransactionalStorage.StorageSource.PIPES) {
            builder.addHeader("pipe", storageSourceName);
        } else {
            builder.addHeader("receiver", storageSourceName);
            builder.addHeader("processState", processState);
        }
        final String[] messageIdArray = this.getMessageIds(input);
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream out) throws IOException {
                try (ZipOutputStream zos = new ZipOutputStream(out);){
                    for (String messageId : messageIdArray) {
                        messageId = HttpUtils.urlDecode((String)messageId);
                        builder.addHeader("messageId", messageId);
                        Message<?> message = CompatiblityTransactionalStorage.this.sendSyncMessage(builder);
                        String mimeType = BusMessageUtils.getHeader(message, (String)"type");
                        String filenameExtension = ".txt";
                        if ("application/json".equals(mimeType)) {
                            filenameExtension = ".json";
                        } else if ("application/xml".equals(mimeType)) {
                            filenameExtension = ".xml";
                        }
                        String payload = (String)message.getPayload();
                        ZipEntry entry = new ZipEntry("msg-" + messageId + filenameExtension);
                        zos.putNextEntry(entry);
                        zos.write(payload.getBytes());
                        zos.closeEntry();
                    }
                }
                catch (IOException e) {
                    throw new ApiException("Failed to create zip file with messages.", e);
                }
            }
        };
        return Response.ok((Object)stream).type("application/octet-stream").header("Content-Disposition", (Object)"attachment; filename=\"messages.zip\"").build();
    }

    private String[] getMessageIds(MultipartBody inputDataMap) {
        String messageIds = RequestUtils.resolveStringFromMap(inputDataMap, "messageIds");
        return messageIds.split(",");
    }

    @GET
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/adapters/{adapterName}/{storageSource}/{storageSourceName}/stores/{processState}")
    @Produces(value={"application/json"})
    @Deprecated
    public Response browseMessagesOld(@PathParam(value="adapterName") String adapterName, @PathParam(value="storageSource") TransactionalStorage.StorageSource storageSource, @PathParam(value="storageSourceName") String storageSourceName, @PathParam(value="processState") String processState, @QueryParam(value="configuration") String configuration, @QueryParam(value="type") String type, @QueryParam(value="host") String host, @QueryParam(value="id") String id, @QueryParam(value="messageId") String messageId, @QueryParam(value="correlationId") String correlationId, @QueryParam(value="comment") String comment, @QueryParam(value="message") String message, @QueryParam(value="label") String label, @QueryParam(value="startDate") String startDateStr, @QueryParam(value="endDate") String endDateStr, @QueryParam(value="sort") String sort, @QueryParam(value="skip") int skipMessages, @QueryParam(value="max") int maxMessages) {
        String config = StringUtils.isNotEmpty((CharSequence)configuration) ? configuration : null;
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.MESSAGE_BROWSER, BusAction.FIND);
        builder.addHeader("configuration", config);
        builder.addHeader("adapter", adapterName);
        if (storageSource == TransactionalStorage.StorageSource.PIPES) {
            builder.addHeader("pipe", storageSourceName);
        } else {
            builder.addHeader("receiver", storageSourceName);
            builder.addHeader("processState", processState);
        }
        builder.addHeader("type", type);
        builder.addHeader("host", host);
        builder.addHeader("idMask", id);
        builder.addHeader("messageId", messageId);
        builder.addHeader("correlationId", correlationId);
        builder.addHeader("comment", comment);
        builder.addHeader("message", message);
        builder.addHeader("label", label);
        builder.addHeader("startDate", startDateStr);
        builder.addHeader("endDate", endDateStr);
        builder.addHeader("sort", sort);
        builder.addHeader("skip", skipMessages);
        builder.addHeader("max", maxMessages);
        return this.callSyncGateway(builder);
    }

    @PUT
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/adapters/{adapterName}/receivers/{receiverName}/stores/Error/messages/{messageId}")
    @Relation(value="pipeline")
    @Produces(value={"application/json"})
    @Deprecated
    public Response resendReceiverMessageOld(@PathParam(value="adapterName") String adapter, @PathParam(value="receiverName") String receiver, @PathParam(value="messageId") String messageId, @QueryParam(value="configuration") String configuration) {
        String config = StringUtils.isNotEmpty((CharSequence)configuration) ? configuration : null;
        messageId = HttpUtils.urlDecode((String)messageId);
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.MESSAGE_BROWSER, BusAction.STATUS);
        builder.addHeader("configuration", config);
        builder.addHeader("adapter", adapter);
        builder.addHeader("receiver", receiver);
        builder.addHeader("messageId", messageId);
        return this.callAsyncGateway(builder);
    }

    @POST
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/adapters/{adapterName}/receivers/{receiverName}/stores/Error")
    @Relation(value="pipeline")
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    @Deprecated
    public Response resendReceiverMessagesOld(@PathParam(value="adapterName") String adapter, @PathParam(value="receiverName") String receiver, @QueryParam(value="configuration") String configuration, MultipartBody input) {
        String config = StringUtils.isNotEmpty((CharSequence)configuration) ? configuration : null;
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.MESSAGE_BROWSER, BusAction.STATUS);
        builder.addHeader("configuration", config);
        builder.addHeader("adapter", adapter);
        builder.addHeader("receiver", receiver);
        String[] messageIds = this.getMessageIds(input);
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (int i = 0; i < messageIds.length; ++i) {
            try {
                builder.addHeader("messageId", messageIds[i]);
                this.callAsyncGateway(builder);
                continue;
            }
            catch (ApiException e) {
                errorMessages.add(e.getCause().getMessage());
                continue;
            }
            catch (Exception e) {
                errorMessages.add(e.getMessage());
            }
        }
        if (errorMessages.isEmpty()) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity(errorMessages).build();
    }

    @POST
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/adapters/{adapterName}/receivers/{receiverName}/stores/{processState}/move/{targetState}")
    @Relation(value="pipeline")
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    @Deprecated
    public Response changeProcessStateOld(@PathParam(value="adapterName") String adapter, @PathParam(value="receiverName") String receiver, @PathParam(value="processState") String processState, @PathParam(value="targetState") String targetState, MultipartBody input, @QueryParam(value="configuration") String configuration) {
        String config = StringUtils.isNotEmpty((CharSequence)configuration) ? configuration : null;
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.MESSAGE_BROWSER, BusAction.MANAGE);
        builder.addHeader("configuration", config);
        builder.addHeader("adapter", adapter);
        builder.addHeader("receiver", receiver);
        builder.addHeader("processState", processState);
        builder.addHeader("targetState", targetState);
        String[] messageIds = this.getMessageIds(input);
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (int i = 0; i < messageIds.length; ++i) {
            try {
                builder.addHeader("messageId", messageIds[i]);
                this.callAsyncGateway(builder);
                continue;
            }
            catch (ApiException e) {
                errorMessages.add(e.getCause().getMessage());
                continue;
            }
            catch (Exception e) {
                errorMessages.add(e.getMessage());
            }
        }
        if (errorMessages.isEmpty()) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity(errorMessages).build();
    }

    @DELETE
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/adapters/{adapterName}/receivers/{receiverName}/stores/Error/messages/{messageId}")
    @Relation(value="pipeline")
    @Produces(value={"application/json"})
    @Deprecated
    public Response deleteReceiverMessageOld(@PathParam(value="adapterName") String adapter, @PathParam(value="receiverName") String receiver, @PathParam(value="messageId") String messageId, @QueryParam(value="configuration") String configuration) {
        String config = StringUtils.isNotEmpty((CharSequence)configuration) ? configuration : null;
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.MESSAGE_BROWSER, BusAction.DELETE);
        builder.addHeader("configuration", config);
        builder.addHeader("adapter", adapter);
        builder.addHeader("receiver", receiver);
        messageId = HttpUtils.urlDecode((String)messageId);
        builder.addHeader("messageId", messageId);
        return this.callAsyncGateway(builder);
    }

    @DELETE
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/adapters/{adapterName}/receivers/{receiverName}/stores/Error")
    @Relation(value="pipeline")
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    @Deprecated
    public Response deleteReceiverMessagesOld(@PathParam(value="adapterName") String adapter, @PathParam(value="receiverName") String receiver, @QueryParam(value="configuration") String configuration, MultipartBody input) {
        String config = StringUtils.isNotEmpty((CharSequence)configuration) ? configuration : null;
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.MESSAGE_BROWSER, BusAction.DELETE);
        builder.addHeader("configuration", config);
        builder.addHeader("adapter", adapter);
        builder.addHeader("receiver", receiver);
        String[] messageIds = this.getMessageIds(input);
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (int i = 0; i < messageIds.length; ++i) {
            try {
                builder.addHeader("messageId", messageIds[i]);
                this.callAsyncGateway(builder);
                continue;
            }
            catch (ApiException e) {
                errorMessages.add(e.getCause().getMessage());
                continue;
            }
            catch (Exception e) {
                errorMessages.add(e.getMessage());
            }
        }
        if (errorMessages.isEmpty()) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity(errorMessages).build();
    }
}

