/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import javax.annotation.security.PermitAll;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import nl.nn.adapterframework.management.web.ApiException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Path(value="/")
public class Authentication {
    @Context
    HttpServletRequest httpServletRequest;
    @Context
    HttpServletResponse httpServletResponse;
    protected Logger log = LogManager.getLogger((Object)this);

    @GET
    @PermitAll
    @Path(value="/logout")
    @Produces(value={"application/json"})
    public Response logout() {
        if (this.httpServletRequest.getUserPrincipal() != null) {
            String user = this.httpServletRequest.getUserPrincipal().getName();
            try {
                this.httpServletRequest.logout();
                this.log.debug("successfully logged out user [" + user + "]");
            }
            catch (ServletException e) {
                throw new ApiException(e);
            }
        } else {
            this.log.debug("unable to log out user, not logged in");
        }
        this.httpServletResponse.setHeader("Refresh", "5");
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }
}

