/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import nl.nn.adapterframework.management.web.ApiException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Provider
public class ApiExceptionHandler
implements ExceptionMapper<WebApplicationException> {
    private Logger log = LogManager.getLogger((Object)this);

    public Response toResponse(WebApplicationException exception) {
        if (exception instanceof ApiException) {
            return ((ApiException)exception).getResponse();
        }
        this.log.warn("Caught unhandled WebApplicationException while executing FF!API call", (Throwable)exception);
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        Response response = exception.getResponse();
        if (response != null && response.getStatus() > 0) {
            status = Response.Status.fromStatusCode((int)response.getStatus());
        }
        return ApiException.formatExceptionResponse(exception.getMessage(), status);
    }
}

