/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import jakarta.json.Json;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonStructure;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import nl.nn.adapterframework.core.IbisException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApiException
extends WebApplicationException
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final transient Logger log = LogManager.getLogger((Object)this);
    private final Response.Status status;
    private final String expandedMessage;
    private transient Response response;

    public ApiException(String msg) {
        this(msg, Response.Status.INTERNAL_SERVER_ERROR);
    }

    public ApiException(Throwable t) {
        this(t, 500);
    }

    public ApiException(String msg, Throwable t) {
        this(msg, t, null);
    }

    private ApiException(Throwable t, int status) {
        this(null, t, Response.Status.fromStatusCode((int)status));
    }

    public ApiException(String msg, int status) {
        this(msg, Response.Status.fromStatusCode((int)status));
    }

    public ApiException(String msg, Response.Status status) {
        this(msg, null, status);
    }

    private ApiException(String msg, Throwable t, Response.Status status) {
        super(msg, t);
        this.status = status != null ? status : Response.Status.INTERNAL_SERVER_ERROR;
        this.expandedMessage = msg == null && t == null ? null : IbisException.expandMessage((String)super.getMessage(), (Throwable)((Object)this), e -> e instanceof IbisException || e instanceof ApiException);
        this.log.warn(this.expandedMessage, t);
    }

    public String getMessage() {
        return this.expandedMessage;
    }

    public Response getResponse() {
        if (this.response == null) {
            this.response = ApiException.formatExceptionResponse(this.expandedMessage, this.status);
        }
        return this.response;
    }

    protected static Response formatExceptionResponse(String message, Response.Status status) {
        Response.ResponseBuilder builder = Response.status((Response.Status)status).type("text/plain");
        if (message != null) {
            JsonObjectBuilder json = Json.createObjectBuilder();
            json.add("status", status.getReasonPhrase());
            json.add("error", message.replace("\n", " ").replace(System.getProperty("line.separator"), " "));
            builder.type("application/json");
            builder.entity((Object)new FormattedJsonEntity((JsonStructure)json.build()));
        }
        return builder.build();
    }

    static class FormattedJsonEntity
    implements StreamingOutput {
        private final JsonWriterFactory factory;
        private final JsonStructure json;

        public FormattedJsonEntity(JsonStructure json) {
            HashMap<String, Boolean> config = new HashMap<String, Boolean>();
            config.put("jakarta.json.stream.JsonGenerator.prettyPrinting", true);
            this.factory = Json.createWriterFactory(config);
            this.json = json;
        }

        public void write(OutputStream output) {
            try (JsonWriter jsonWriter = this.factory.createWriter(output, StandardCharsets.UTF_8);){
                jsonWriter.write(this.json);
            }
        }
    }
}

