/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.gateway;

import java.util.ArrayList;
import java.util.List;
import nl.nn.adapterframework.management.bus.BusException;
import nl.nn.adapterframework.management.gateway.InputStreamHttpMessageConverter;
import nl.nn.adapterframework.management.security.JwtKeyGenerator;
import nl.nn.adapterframework.util.SpringUtils;
import nl.nn.adapterframework.util.StreamUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.http.outbound.HttpRequestExecutingMessageHandler;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;

public class HttpOutboundHandler
extends HttpRequestExecutingMessageHandler {
    @Autowired
    private JwtKeyGenerator jwtGenerator;

    public HttpOutboundHandler(String endpoint) {
        super(endpoint);
    }

    protected void doInit() {
        if (this.jwtGenerator == null) {
            throw new IllegalStateException("JwtKeyGenerator not set");
        }
        super.doInit();
        QueueChannel responseChannel = (QueueChannel)SpringUtils.createBean((ApplicationContext)this.getApplicationContext(), QueueChannel.class);
        this.setOutputChannel((MessageChannel)responseChannel);
        DefaultHttpHeaderMapper headerMapper = (DefaultHttpHeaderMapper)SpringUtils.createBean((ApplicationContext)this.getApplicationContext(), DefaultHttpHeaderMapper.class);
        headerMapper.setOutboundHeaderNames(this.getRequestHeaders());
        headerMapper.setInboundHeaderNames(new String[]{"meta-*"});
        this.setHeaderMapper((HeaderMapper)headerMapper);
        this.setMessageConverters(this.getMessageConverters());
        this.setHttpMethodExpression((Expression)new HttpMethodExpression());
    }

    private List<HttpMessageConverter<?>> getMessageConverters() {
        ArrayList messageConverters = new ArrayList();
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter(StreamUtil.DEFAULT_CHARSET);
        stringHttpMessageConverter.setWriteAcceptCharset(false);
        messageConverters.add((HttpMessageConverter<?>)stringHttpMessageConverter);
        messageConverters.add((HttpMessageConverter<?>)new InputStreamHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        return messageConverters;
    }

    private String[] getRequestHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("action");
        headers.add("topic");
        headers.add("meta-*");
        return headers.toArray(new String[0]);
    }

    protected HttpHeaders mapHeaders(Message<?> message) {
        HttpHeaders headers = super.mapHeaders(message);
        headers.add("Authentication", "Bearer " + this.jwtGenerator.create());
        return headers;
    }

    public Message handleRequestMessage(Message<?> requestMessage) {
        Object response = super.handleRequestMessage(requestMessage);
        if (response instanceof Message) {
            return (Message)response;
        }
        if (response instanceof MessageBuilder) {
            return ((MessageBuilder)response).build();
        }
        throw new BusException("unknown response type [" + (response != null ? response.getClass().getCanonicalName() : "null") + "]");
    }

    protected Object resolveErrorChannel(MessageHeaders requestHeaders) {
        return this.getOutputChannel();
    }

    protected Object evaluateTypeFromExpression(Message<?> requestMessage, Expression expression, String property) {
        if ("expectedResponseType".equals(property)) {
            return byte[].class;
        }
        return super.evaluateTypeFromExpression(requestMessage, expression, property);
    }

    private static class HttpMethodExpression
    extends ValueExpression<HttpMethod> {
        public HttpMethodExpression() {
            super((Object)HttpMethod.POST);
        }

        public HttpMethod getValue(EvaluationContext context, Object rootObject) throws EvaluationException {
            if (rootObject instanceof Message && "NONE".equals(((Message)rootObject).getPayload())) {
                return HttpMethod.GET;
            }
            return (HttpMethod)super.getValue(context, rootObject);
        }
    }
}

