/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.gateway;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.HttpConstraintElement;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;
import nl.nn.adapterframework.management.gateway.ErrorMessageConverter;
import nl.nn.adapterframework.management.gateway.InputStreamHttpMessageConverter;
import nl.nn.adapterframework.management.security.JwtSecurityFilter;
import nl.nn.adapterframework.util.SpringUtils;
import nl.nn.adapterframework.util.StreamUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.Order;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.integration.IntegrationPattern;
import org.springframework.integration.IntegrationPatternType;
import org.springframework.integration.channel.PublishSubscribeChannel;
import org.springframework.integration.http.inbound.HttpRequestHandlingMessagingGateway;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.support.HttpRequestHandlerServlet;
import org.springframework.web.filter.RequestContextFilter;

@Order(value=0x7FFFFFFE)
public class HttpInboundGateway
implements WebSecurityConfigurer<WebSecurity>,
ServletContextAware,
IntegrationPattern,
InitializingBean,
ApplicationContextAware,
BeanFactoryAware {
    private static final String HTTP_SECURITY_BEAN_NAME = "org.springframework.security.config.annotation.web.configuration.HttpSecurityConfiguration.httpSecurity";
    private static final String SERVLET_NAME = "HttpInboundGatewayServlet";
    private final Logger log = LogManager.getLogger(HttpInboundGateway.class);
    private HttpRequestHandlingMessagingGateway gateway;
    private ApplicationContext applicationContext;
    private BeanFactory beanFactory;
    private ServletContext servletContext;
    @Value(value="${management.gateway.http.inbound.path:/iaf/management}")
    private String httpPath;

    public void afterPropertiesSet() {
        if (this.applicationContext == null) {
            throw new IllegalStateException("no ApplicationContext set");
        }
        if (this.gateway == null) {
            this.createGateway();
            this.createGatewayEndpoint();
        }
    }

    private void createGateway() {
        this.gateway = (HttpRequestHandlingMessagingGateway)SpringUtils.createBean((ApplicationContext)this.applicationContext, HttpRequestHandlingMessagingGateway.class);
        this.gateway.setRequestChannel(this.getRequestChannel(this.applicationContext));
        this.gateway.setErrorChannel((MessageChannel)this.getErrorChannel(this.applicationContext));
        this.gateway.setMessageConverters(this.getMessageConverters());
        this.gateway.setErrorOnTimeout(false);
        this.gateway.setRequestTimeout(0L);
        this.gateway.setReplyTimeout(0L);
        DefaultHttpHeaderMapper headerMapper = (DefaultHttpHeaderMapper)SpringUtils.createBean((ApplicationContext)this.applicationContext, DefaultHttpHeaderMapper.class);
        headerMapper.setInboundHeaderNames(this.getRequestHeaders());
        headerMapper.setOutboundHeaderNames(new String[]{"meta-*"});
        this.gateway.setHeaderMapper((HeaderMapper)headerMapper);
        ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)this.beanFactory;
        cbf.registerSingleton(SERVLET_NAME, (Object)this.gateway);
    }

    public void createGatewayEndpoint() {
        HttpRequestHandlerServlet servlet = new HttpRequestHandlerServlet();
        this.log.info("created management service endpoint [{}]", (Object)this.httpPath);
        ServletRegistration.Dynamic serv = this.servletContext.addServlet(SERVLET_NAME, (Servlet)servlet);
        serv.setLoadOnStartup(-1);
        serv.addMapping(new String[]{this.httpPath});
        HttpConstraintElement httpConstraintElement = new HttpConstraintElement(ServletSecurity.TransportGuarantee.NONE, new String[0]);
        serv.setServletSecurity(new ServletSecurityElement(httpConstraintElement));
    }

    private String[] getRequestHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("action");
        headers.add("topic");
        headers.add("meta-*");
        return headers.toArray(new String[0]);
    }

    private MessageChannel getRequestChannel(ApplicationContext applicationContext) {
        return (MessageChannel)applicationContext.getBean("frank-management-bus", MessageChannel.class);
    }

    private SubscribableChannel getErrorChannel(ApplicationContext applicationContext) {
        PublishSubscribeChannel channel = (PublishSubscribeChannel)SpringUtils.createBean((ApplicationContext)applicationContext, PublishSubscribeChannel.class);
        channel.setBeanName("ErrorMessageConvertingChannel");
        ErrorMessageConverter errorConverter = (ErrorMessageConverter)((Object)SpringUtils.createBean((ApplicationContext)applicationContext, ErrorMessageConverter.class));
        if (channel.subscribe((MessageHandler)errorConverter)) {
            this.log.info("created ErrorMessageConverter [{}]", (Object)errorConverter);
        } else {
            this.log.info("unable to create ErrorMessageConverter, all errors wil be ingored");
            this.gateway.setErrorOnTimeout(false);
        }
        return channel;
    }

    private List<HttpMessageConverter<?>> getMessageConverters() {
        ArrayList messageConverters = new ArrayList();
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter(StreamUtil.DEFAULT_CHARSET);
        stringHttpMessageConverter.setWriteAcceptCharset(false);
        messageConverters.add((HttpMessageConverter<?>)stringHttpMessageConverter);
        messageConverters.add((HttpMessageConverter<?>)new InputStreamHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        return messageConverters;
    }

    public IntegrationPatternType getIntegrationPatternType() {
        return IntegrationPatternType.inbound_gateway;
    }

    public void init(WebSecurity builder) throws Exception {
    }

    public void configure(WebSecurity builder) throws Exception {
        builder.addSecurityFilterChainBuilder(this::createSecurityFilterChain);
    }

    private SecurityFilterChain createSecurityFilterChain() {
        HttpSecurity httpSecurityConfigurer = (HttpSecurity)this.applicationContext.getBean(HTTP_SECURITY_BEAN_NAME, HttpSecurity.class);
        return this.configureHttpSecurity(httpSecurityConfigurer);
    }

    private SecurityFilterChain configureHttpSecurity(HttpSecurity http) {
        try {
            http.headers().frameOptions().sameOrigin();
            http.csrf().disable();
            http.securityMatcher((RequestMatcher)new AntPathRequestMatcher(this.httpPath));
            http.formLogin().disable();
            http.anonymous().disable();
            http.logout().disable();
            http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED);
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)http.authorizeHttpRequests().anyRequest()).authenticated();
            Filter requestDispatcher = (Filter)SpringUtils.createBean((ApplicationContext)this.applicationContext, RequestContextFilter.class);
            http.addFilterAfter(requestDispatcher, AuthorizationFilter.class);
            JwtSecurityFilter securityFilter = (JwtSecurityFilter)SpringUtils.createBean((ApplicationContext)this.applicationContext, JwtSecurityFilter.class);
            http.addFilterBefore((Filter)securityFilter, BasicAuthenticationFilter.class);
            return (SecurityFilterChain)http.build();
        }
        catch (Exception e) {
            throw new IllegalStateException("unable to configure Spring Security", e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

