/*
   Copyright 2021 Nationale-Nederlanden, 2022 WeAreFrank!

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package nl.nn.credentialprovider;

import java.util.Collection;

public class WebSphereCredentialFactory implements ICredentialFactory {

	@Override
	public ICredentials getCredentials(String alias, String defaultUsername, String defaultPassword) {
		return new WebSphereCredentials(alias, defaultUsername, defaultPassword);
	}


	@Override
	public boolean hasCredentials(String alias) {
		WebSphereCredentials credentials = new WebSphereCredentials(alias, null, null);
		return credentials.isAliasFound();
	}

	@Override
	public Collection<String> getConfiguredAliases() {
		return null; // don't know how to list JAAS authentication aliases programmatically
	}
}
