/*
   Copyright 2021, 2022 WeAreFrank!

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package nl.nn.credentialprovider;

import java.util.Collection;

public interface ICredentialFactory {

	/**
	 * initialize() of an implementation can throw an exception when the credentialFactory cannot be properly configured and used.
	 * @throws Exception
	 */
	default void initialize() throws Exception {
		// implementations can do their initialization, and throw an exception if they cannot.
	};

	public boolean hasCredentials(String alias);

	public ICredentials getCredentials(String alias, String defaultUsername, String defaultPassword);

	/**
	 * return a list of all configured aliases, or null if such a list cannot be provided.
	 * @throws Exception
	 */
	public Collection<String> getConfiguredAliases() throws Exception;
}
