/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client.identity;

import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import org.hyperledger.fabric.client.identity.ECPrivateKeySigner;
import org.hyperledger.fabric.client.identity.PrivateKeySigner;
import org.hyperledger.fabric.client.identity.Signer;

public final class Signers {
    private static final String ED25519_ALGORITHM = "Ed25519";

    public static Signer newPrivateKeySigner(PrivateKey privateKey) {
        if (privateKey instanceof ECPrivateKey) {
            return new ECPrivateKeySigner((ECPrivateKey)privateKey);
        }
        if (ED25519_ALGORITHM.equals(privateKey.getAlgorithm())) {
            return new PrivateKeySigner(privateKey, ED25519_ALGORITHM);
        }
        throw new IllegalArgumentException("Unsupported private key type: " + privateKey.getClass().getTypeName() + " (" + privateKey.getAlgorithm() + ")");
    }

    private Signers() {
    }
}

