/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client.identity;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.hyperledger.fabric.client.identity.Signer;

final class PrivateKeySigner
implements Signer {
    private static final Provider PROVIDER = new BouncyCastleProvider();
    private final PrivateKey privateKey;
    private final String algorithm;

    PrivateKeySigner(PrivateKey privateKey, String algorithm) {
        this.privateKey = privateKey;
        this.algorithm = algorithm;
    }

    @Override
    public byte[] sign(byte[] digest) throws GeneralSecurityException {
        Signature signer = Signature.getInstance(this.algorithm, PROVIDER);
        signer.initSign(this.privateKey);
        signer.update(digest);
        return signer.sign();
    }
}

