/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client.identity;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.interfaces.ECPrivateKey;
import org.bouncycastle.asn1.ASN1Integer;
import org.hyperledger.fabric.client.identity.ECSignature;
import org.hyperledger.fabric.client.identity.PrivateKeySigner;
import org.hyperledger.fabric.client.identity.Signer;

final class ECPrivateKeySigner
implements Signer {
    private static final String ALGORITHM_NAME = "NONEwithECDSA";
    private final Signer signer;
    private final BigInteger curveN;
    private final BigInteger halfCurveN;

    ECPrivateKeySigner(ECPrivateKey privateKey) {
        this.signer = new PrivateKeySigner(privateKey, ALGORITHM_NAME);
        this.curveN = privateKey.getParams().getOrder();
        this.halfCurveN = this.curveN.divide(BigInteger.valueOf(2L));
    }

    @Override
    public byte[] sign(byte[] digest) throws GeneralSecurityException {
        byte[] rawSignature = this.signer.sign(digest);
        ECSignature signature = ECSignature.fromBytes(rawSignature);
        signature = this.preventMalleability(signature);
        return signature.getBytes();
    }

    private ECSignature preventMalleability(ECSignature signature) {
        BigInteger s = signature.getS().getValue();
        if (s.compareTo(this.halfCurveN) > 0) {
            s = this.curveN.subtract(s);
            return new ECSignature(signature.getR(), new ASN1Integer(s));
        }
        return signature;
    }
}

