/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import java.security.GeneralSecurityException;
import java.security.ProviderException;
import java.util.function.Function;
import org.hyperledger.fabric.client.GatewayUtils;
import org.hyperledger.fabric.client.identity.Identity;
import org.hyperledger.fabric.client.identity.Signer;
import org.hyperledger.fabric.protos.msp.SerializedIdentity;

final class SigningIdentity {
    private final Identity identity;
    private final Function<byte[], byte[]> hash;
    private final Signer signer;
    private final SerializedIdentity creator;

    SigningIdentity(Identity identity, Function<byte[], byte[]> hash, Signer signer) {
        this.identity = identity;
        this.hash = hash;
        this.signer = signer;
        GatewayUtils.requireNonNullArgument(this.identity, "No identity supplied");
        GatewayUtils.requireNonNullArgument(this.hash, "No hash implementation supplied");
        GatewayUtils.requireNonNullArgument(this.signer, "No signing implementation supplied");
        this.creator = GatewayUtils.newSerializedIdentity(identity);
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public byte[] hash(byte[] message) {
        return this.hash.apply(message);
    }

    public byte[] sign(byte[] digest) {
        try {
            return this.signer.sign(digest);
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException(e);
        }
    }

    public byte[] getCreator() {
        return this.creator.toByteArray();
    }
}

