/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.ByteString;
import org.hyperledger.fabric.client.Signable;
import org.hyperledger.fabric.client.SigningIdentity;
import org.hyperledger.fabric.protos.common.Envelope;

class SignableBlockEventsRequest
implements Signable {
    private final SigningIdentity signingIdentity;
    private Envelope request;

    SignableBlockEventsRequest(SigningIdentity signingIdentity, Envelope request) {
        this.signingIdentity = signingIdentity;
        this.request = request;
    }

    protected Envelope getSignedRequest() {
        if (!this.isSigned()) {
            byte[] digest = this.getDigest();
            byte[] signature = this.signingIdentity.sign(digest);
            this.setSignature(signature);
        }
        return this.request;
    }

    @Override
    public byte[] getBytes() {
        return this.request.toByteArray();
    }

    @Override
    public byte[] getDigest() {
        byte[] message = this.request.getPayload().toByteArray();
        return this.signingIdentity.hash(message);
    }

    void setSignature(byte[] signature) {
        this.request = this.request.toBuilder().setSignature(ByteString.copyFrom((byte[])signature)).build();
    }

    private boolean isSigned() {
        return !this.request.getSignature().isEmpty();
    }
}

