/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import io.grpc.CallOptions;
import java.util.function.UnaryOperator;
import org.hyperledger.fabric.client.BlockAndPrivateDataEventsRequest;
import org.hyperledger.fabric.client.BlockEventsRequest;
import org.hyperledger.fabric.client.CallOption;
import org.hyperledger.fabric.client.ChaincodeEvent;
import org.hyperledger.fabric.client.ChaincodeEventsRequest;
import org.hyperledger.fabric.client.CloseableIterator;
import org.hyperledger.fabric.client.Contract;
import org.hyperledger.fabric.client.FilteredBlockEventsRequest;
import org.hyperledger.fabric.client.GatewayUtils;
import org.hyperledger.fabric.protos.common.Block;
import org.hyperledger.fabric.protos.peer.BlockAndPrivateData;
import org.hyperledger.fabric.protos.peer.FilteredBlock;

public interface Network {
    public Contract getContract(String var1);

    public Contract getContract(String var1, String var2);

    public String getName();

    default public CloseableIterator<ChaincodeEvent> getChaincodeEvents(String chaincodeName) {
        return this.getChaincodeEvents(chaincodeName, GatewayUtils.asCallOptions(new CallOption[0]));
    }

    public CloseableIterator<ChaincodeEvent> getChaincodeEvents(String var1, UnaryOperator<CallOptions> var2);

    @Deprecated
    default public CloseableIterator<ChaincodeEvent> getChaincodeEvents(String chaincodeName, CallOption ... options) {
        return this.getChaincodeEvents(chaincodeName, GatewayUtils.asCallOptions(options));
    }

    public ChaincodeEventsRequest.Builder newChaincodeEventsRequest(String var1);

    default public CloseableIterator<Block> getBlockEvents() {
        return this.getBlockEvents(GatewayUtils.asCallOptions(new CallOption[0]));
    }

    public CloseableIterator<Block> getBlockEvents(UnaryOperator<CallOptions> var1);

    public BlockEventsRequest.Builder newBlockEventsRequest();

    default public CloseableIterator<FilteredBlock> getFilteredBlockEvents() {
        return this.getFilteredBlockEvents(GatewayUtils.asCallOptions(new CallOption[0]));
    }

    public CloseableIterator<FilteredBlock> getFilteredBlockEvents(UnaryOperator<CallOptions> var1);

    public FilteredBlockEventsRequest.Builder newFilteredBlockEventsRequest();

    default public CloseableIterator<BlockAndPrivateData> getBlockAndPrivateDataEvents() {
        return this.getBlockAndPrivateDataEvents(GatewayUtils.asCallOptions(new CallOption[0]));
    }

    public CloseableIterator<BlockAndPrivateData> getBlockAndPrivateDataEvents(UnaryOperator<CallOptions> var1);

    public BlockAndPrivateDataEventsRequest.Builder newBlockAndPrivateDataEventsRequest();
}

