/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.function.Function;

public enum Hash implements Function<byte[], byte[]>
{
    NONE(Function.identity()),
    SHA256(message -> Hash.digest("SHA-256", message)),
    SHA384(message -> Hash.digest("SHA-384", message)),
    SHA3_256(message -> Hash.digest("SHA3-256", message)),
    SHA3_384(message -> Hash.digest("SHA3-384", message));

    private final Function<byte[], byte[]> implementation;

    @Deprecated
    public static byte[] sha256(byte[] message) {
        return SHA256.apply(message);
    }

    private Hash(Function<byte[], byte[]> implementation) {
        this.implementation = implementation;
    }

    @Override
    public byte[] apply(byte[] message) {
        return this.implementation.apply(message);
    }

    private static byte[] digest(String algorithm, byte[] message) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            return digest.digest(message);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }
}

