/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import io.grpc.stub.AbstractStub;
import java.util.function.UnaryOperator;

final class DefaultCallOptions {
    private final UnaryOperator<CallOptions> evaluate;
    private final UnaryOperator<CallOptions> endorse;
    private final UnaryOperator<CallOptions> submit;
    private final UnaryOperator<CallOptions> commitStatus;
    private final UnaryOperator<CallOptions> chaincodeEvents;
    private final UnaryOperator<CallOptions> blockEvents;
    private final UnaryOperator<CallOptions> filteredBlockEvents;
    private final UnaryOperator<CallOptions> blockAndPrivateDataEvents;

    private DefaultCallOptions(Builder builder) {
        this.evaluate = builder.evaluate;
        this.endorse = builder.endorse;
        this.submit = builder.submit;
        this.commitStatus = builder.commitStatus;
        this.chaincodeEvents = builder.chaincodeEvents;
        this.blockEvents = builder.blockEvents;
        this.filteredBlockEvents = builder.filteredBlockEvents;
        this.blockAndPrivateDataEvents = builder.blockAndPrivateDataEvents;
    }

    public static Builder newBuiler() {
        return new Builder();
    }

    public <T extends AbstractStub<T>> T applyEvaluate(T stub, UnaryOperator<CallOptions> additional) {
        return DefaultCallOptions.applyOptions(DefaultCallOptions.applyOptions(stub, additional), this.evaluate);
    }

    public <T extends AbstractStub<T>> T applyEndorse(T stub, UnaryOperator<CallOptions> additional) {
        return DefaultCallOptions.applyOptions(DefaultCallOptions.applyOptions(stub, additional), this.endorse);
    }

    public <T extends AbstractStub<T>> T applySubmit(T stub, UnaryOperator<CallOptions> additional) {
        return DefaultCallOptions.applyOptions(DefaultCallOptions.applyOptions(stub, additional), this.submit);
    }

    public <T extends AbstractStub<T>> T applyCommitStatus(T stub, UnaryOperator<CallOptions> additional) {
        return DefaultCallOptions.applyOptions(DefaultCallOptions.applyOptions(stub, additional), this.commitStatus);
    }

    public <T extends AbstractStub<T>> T applyChaincodeEvents(T stub, UnaryOperator<CallOptions> additional) {
        return DefaultCallOptions.applyOptions(DefaultCallOptions.applyOptions(stub, additional), this.chaincodeEvents);
    }

    public <T extends AbstractStub<T>> T applyBlockEvents(T stub, UnaryOperator<CallOptions> additional) {
        return DefaultCallOptions.applyOptions(DefaultCallOptions.applyOptions(stub, additional), this.blockEvents);
    }

    public <T extends AbstractStub<T>> T applyFilteredBlockEvents(T stub, UnaryOperator<CallOptions> additional) {
        return DefaultCallOptions.applyOptions(DefaultCallOptions.applyOptions(stub, additional), this.filteredBlockEvents);
    }

    public <T extends AbstractStub<T>> T applyBlockAndPrivateDataEvents(T stub, UnaryOperator<CallOptions> additional) {
        return DefaultCallOptions.applyOptions(DefaultCallOptions.applyOptions(stub, additional), this.blockAndPrivateDataEvents);
    }

    private static <T extends AbstractStub<T>> T applyOptions(T stub, final UnaryOperator<CallOptions> operator) {
        if (operator == null) {
            return stub;
        }
        return (T)stub.withInterceptors(new ClientInterceptor[]{new ClientInterceptor(){

            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
                return channel.newCall(methodDescriptor, (CallOptions)operator.apply(callOptions));
            }
        }});
    }

    public static final class Builder {
        private UnaryOperator<CallOptions> evaluate;
        private UnaryOperator<CallOptions> endorse;
        private UnaryOperator<CallOptions> submit;
        private UnaryOperator<CallOptions> commitStatus;
        private UnaryOperator<CallOptions> chaincodeEvents;
        private UnaryOperator<CallOptions> blockEvents;
        private UnaryOperator<CallOptions> filteredBlockEvents;
        private UnaryOperator<CallOptions> blockAndPrivateDataEvents;

        private Builder() {
        }

        public Builder evaluate(UnaryOperator<CallOptions> options) {
            this.evaluate = options;
            return this;
        }

        public Builder endorse(UnaryOperator<CallOptions> options) {
            this.endorse = options;
            return this;
        }

        public Builder submit(UnaryOperator<CallOptions> options) {
            this.submit = options;
            return this;
        }

        public Builder commitStatus(UnaryOperator<CallOptions> options) {
            this.commitStatus = options;
            return this;
        }

        public Builder chaincodeEvents(UnaryOperator<CallOptions> options) {
            this.chaincodeEvents = options;
            return this;
        }

        public Builder blockEvents(UnaryOperator<CallOptions> options) {
            this.blockEvents = options;
            return this;
        }

        public Builder filteredBlockEvents(UnaryOperator<CallOptions> options) {
            this.filteredBlockEvents = options;
            return this;
        }

        public Builder blockAndPrivateDataEvents(UnaryOperator<CallOptions> options) {
            this.blockAndPrivateDataEvents = options;
            return this;
        }

        public DefaultCallOptions build() {
            return new DefaultCallOptions(this);
        }
    }
}

