/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.ByteString;
import org.hyperledger.fabric.client.GatewayUtils;
import org.hyperledger.fabric.client.SigningIdentity;
import org.hyperledger.fabric.client.StartPositionBuilder;
import org.hyperledger.fabric.protos.common.ChannelHeader;
import org.hyperledger.fabric.protos.common.Envelope;
import org.hyperledger.fabric.protos.common.Header;
import org.hyperledger.fabric.protos.common.Payload;
import org.hyperledger.fabric.protos.common.SignatureHeader;
import org.hyperledger.fabric.protos.orderer.SeekInfo;

final class BlockEventsEnvelopeBuilder {
    private final SigningIdentity signingIdentity;
    private final String channelName;
    private final ByteString tlsCertificateHash;
    private final StartPositionBuilder startPositionBuilder = new StartPositionBuilder();

    BlockEventsEnvelopeBuilder(SigningIdentity signingIdentity, String channelName, ByteString tlsCertificateHash) {
        this.signingIdentity = signingIdentity;
        this.channelName = channelName;
        this.tlsCertificateHash = tlsCertificateHash;
    }

    public BlockEventsEnvelopeBuilder startBlock(long blockNumber) {
        this.startPositionBuilder.startBlock(blockNumber);
        return this;
    }

    public Envelope build() {
        return Envelope.newBuilder().setPayload(this.newPayload().toByteString()).build();
    }

    private Payload newPayload() {
        return Payload.newBuilder().setHeader(this.newHeader()).setData(this.newSeekInfo().toByteString()).build();
    }

    private Header newHeader() {
        return Header.newBuilder().setChannelHeader(this.newChannelHeader().toByteString()).setSignatureHeader(this.newSignatureHeader().toByteString()).build();
    }

    private ChannelHeader newChannelHeader() {
        return ChannelHeader.newBuilder().setChannelId(this.channelName).setEpoch(0L).setTimestamp(GatewayUtils.getCurrentTimestamp()).setType(5).setTlsCertHash(this.tlsCertificateHash).build();
    }

    private SignatureHeader newSignatureHeader() {
        ByteString creator = ByteString.copyFrom((byte[])this.signingIdentity.getCreator());
        return SignatureHeader.newBuilder().setCreator(creator).build();
    }

    private SeekInfo newSeekInfo() {
        return SeekInfo.newBuilder().setStart(this.startPositionBuilder.build()).setStop(GatewayUtils.seekLargestBlockNumber()).build();
    }
}

