/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.ByteString;
import java.util.Objects;
import org.hyperledger.fabric.client.BlockEventsEnvelopeBuilder;
import org.hyperledger.fabric.client.BlockEventsRequest;
import org.hyperledger.fabric.client.BlockEventsRequestImpl;
import org.hyperledger.fabric.client.Checkpoint;
import org.hyperledger.fabric.client.GatewayClient;
import org.hyperledger.fabric.client.SigningIdentity;
import org.hyperledger.fabric.protos.common.Envelope;

final class BlockEventsBuilder
implements BlockEventsRequest.Builder {
    private final GatewayClient client;
    private final SigningIdentity signingIdentity;
    private final BlockEventsEnvelopeBuilder envelopeBuilder;

    BlockEventsBuilder(GatewayClient client, SigningIdentity signingIdentity, String channelName, ByteString tlsCertificateHash) {
        Objects.requireNonNull(channelName, "channel name");
        this.client = client;
        this.signingIdentity = signingIdentity;
        this.envelopeBuilder = new BlockEventsEnvelopeBuilder(signingIdentity, channelName, tlsCertificateHash);
    }

    @Override
    public BlockEventsBuilder startBlock(long blockNumber) {
        this.envelopeBuilder.startBlock(blockNumber);
        return this;
    }

    @Override
    public BlockEventsBuilder checkpoint(Checkpoint checkpoint) {
        checkpoint.getBlockNumber().ifPresent(this.envelopeBuilder::startBlock);
        return this;
    }

    @Override
    public BlockEventsRequest build() {
        Envelope request = this.envelopeBuilder.build();
        return new BlockEventsRequestImpl(this.client, this.signingIdentity, request);
    }
}

