/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import io.grpc.CallOptions;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.hyperledger.fabric.client.BlockAndPrivateDataEventsBuilder;
import org.hyperledger.fabric.client.BlockAndPrivateDataEventsRequest;
import org.hyperledger.fabric.client.BlockEventsBuilder;
import org.hyperledger.fabric.client.BlockEventsRequest;
import org.hyperledger.fabric.client.ChaincodeEvent;
import org.hyperledger.fabric.client.ChaincodeEventsBuilder;
import org.hyperledger.fabric.client.ChaincodeEventsRequest;
import org.hyperledger.fabric.client.CloseableIterator;
import org.hyperledger.fabric.client.Contract;
import org.hyperledger.fabric.client.ContractImpl;
import org.hyperledger.fabric.client.FilteredBlockEventsBuilder;
import org.hyperledger.fabric.client.FilteredBlockEventsRequest;
import org.hyperledger.fabric.client.GatewayClient;
import org.hyperledger.fabric.client.Network;
import org.hyperledger.fabric.client.SigningIdentity;
import org.hyperledger.fabric.protos.common.Block;
import org.hyperledger.fabric.protos.peer.BlockAndPrivateData;
import org.hyperledger.fabric.protos.peer.FilteredBlock;

final class NetworkImpl
implements Network {
    private final GatewayClient client;
    private final SigningIdentity signingIdentity;
    private final String channelName;

    NetworkImpl(GatewayClient client, SigningIdentity signingIdentity, String channelName) {
        Objects.requireNonNull(channelName, "network name");
        this.client = client;
        this.signingIdentity = signingIdentity;
        this.channelName = channelName;
    }

    @Override
    public Contract getContract(String chaincodeName, String contractName) {
        return new ContractImpl(this.client, this.signingIdentity, this.channelName, chaincodeName, contractName);
    }

    @Override
    public Contract getContract(String chaincodeName) {
        return new ContractImpl(this.client, this.signingIdentity, this.channelName, chaincodeName);
    }

    @Override
    public String getName() {
        return this.channelName;
    }

    @Override
    public CloseableIterator<ChaincodeEvent> getChaincodeEvents(String chaincodeName, UnaryOperator<CallOptions> options) {
        return this.newChaincodeEventsRequest(chaincodeName).build().getEvents(options);
    }

    @Override
    public ChaincodeEventsRequest.Builder newChaincodeEventsRequest(String chaincodeName) {
        return new ChaincodeEventsBuilder(this.client, this.signingIdentity, this.channelName, chaincodeName);
    }

    @Override
    public CloseableIterator<Block> getBlockEvents(UnaryOperator<CallOptions> options) {
        return this.newBlockEventsRequest().build().getEvents(options);
    }

    @Override
    public BlockEventsRequest.Builder newBlockEventsRequest() {
        return new BlockEventsBuilder(this.client, this.signingIdentity, this.channelName);
    }

    @Override
    public CloseableIterator<FilteredBlock> getFilteredBlockEvents(UnaryOperator<CallOptions> options) {
        return this.newFilteredBlockEventsRequest().build().getEvents(options);
    }

    @Override
    public FilteredBlockEventsRequest.Builder newFilteredBlockEventsRequest() {
        return new FilteredBlockEventsBuilder(this.client, this.signingIdentity, this.channelName);
    }

    @Override
    public CloseableIterator<BlockAndPrivateData> getBlockAndPrivateDataEvents(UnaryOperator<CallOptions> options) {
        return this.newBlockAndPrivateDataEventsRequest().build().getEvents(options);
    }

    @Override
    public BlockAndPrivateDataEventsRequest.Builder newBlockAndPrivateDataEventsRequest() {
        return new BlockAndPrivateDataEventsBuilder(this.client, this.signingIdentity, this.channelName);
    }
}

