/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client.identity;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPKCS8Generator;
import org.bouncycastle.util.io.pem.PemGenerationException;
import org.bouncycastle.util.io.pem.PemObject;

public final class Identities {
    public static X509Certificate readX509Certificate(String pem) throws CertificateException {
        try {
            return Identities.readX509Certificate(new StringReader(pem));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static X509Certificate readX509Certificate(Reader pemReader) throws IOException, CertificateException {
        try {
            Object pemObject = Identities.readPemObject(pemReader);
            X509CertificateHolder certificateHolder = Identities.asX509CertificateHolder(pemObject);
            return new JcaX509CertificateConverter().getCertificate(certificateHolder);
        }
        catch (PEMException e) {
            throw new CertificateException(e);
        }
    }

    private static Object readPemObject(Reader reader) throws IOException {
        try (PEMParser parser = new PEMParser(reader);){
            Object result = parser.readObject();
            if (result == null) {
                throw new PEMException("Invalid PEM content");
            }
            Object object = result;
            return object;
        }
    }

    private static X509CertificateHolder asX509CertificateHolder(Object pemObject) throws CertificateException {
        if (pemObject instanceof X509CertificateHolder) {
            return (X509CertificateHolder)pemObject;
        }
        throw new CertificateException("Unexpected PEM content type: " + pemObject.getClass().getSimpleName());
    }

    public static PrivateKey readPrivateKey(String pem) throws InvalidKeyException {
        try {
            return Identities.readPrivateKey(new StringReader(pem));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static PrivateKey readPrivateKey(Reader pemReader) throws IOException, InvalidKeyException {
        try {
            Object pemObject = Identities.readPemObject(pemReader);
            PrivateKeyInfo privateKeyInfo = Identities.asPrivateKeyInfo(pemObject);
            return new JcaPEMKeyConverter().getPrivateKey(privateKeyInfo);
        }
        catch (PEMException e) {
            throw new InvalidKeyException(e);
        }
    }

    private static PrivateKeyInfo asPrivateKeyInfo(Object pemObject) throws InvalidKeyException {
        PrivateKeyInfo privateKeyInfo;
        if (pemObject instanceof PEMKeyPair) {
            privateKeyInfo = ((PEMKeyPair)pemObject).getPrivateKeyInfo();
        } else if (pemObject instanceof PrivateKeyInfo) {
            privateKeyInfo = (PrivateKeyInfo)pemObject;
        } else {
            throw new InvalidKeyException("Unexpected PEM content type: " + pemObject.getClass().getSimpleName());
        }
        return privateKeyInfo;
    }

    public static String toPemString(Certificate certificate) {
        return Identities.asPemString(certificate);
    }

    private static String asPemString(Object obj) {
        StringWriter stringWriter = new StringWriter();
        try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);){
            pemWriter.writeObject(obj);
            pemWriter.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return stringWriter.toString();
    }

    public static String toPemString(PrivateKey privateKey) {
        try {
            PemObject pkcs8PrivateKey = new JcaPKCS8Generator(privateKey, null).generate();
            return Identities.asPemString(pkcs8PrivateKey);
        }
        catch (PemGenerationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Identities() {
    }
}

