/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import org.hyperledger.fabric.protos.common.ChannelHeader;
import org.hyperledger.fabric.protos.common.Envelope;
import org.hyperledger.fabric.protos.common.Header;
import org.hyperledger.fabric.protos.common.Payload;
import org.hyperledger.fabric.protos.peer.ChaincodeAction;
import org.hyperledger.fabric.protos.peer.ChaincodeActionPayload;
import org.hyperledger.fabric.protos.peer.ProposalResponsePayload;
import org.hyperledger.fabric.protos.peer.Transaction;
import org.hyperledger.fabric.protos.peer.TransactionAction;

final class TransactionEnvelopeParser {
    private final String channelName;
    private final ByteString result;

    TransactionEnvelopeParser(Envelope envelope) {
        try {
            Payload payload = Payload.parseFrom((ByteString)envelope.getPayload());
            this.channelName = this.parseChannelName(payload.getHeader());
            this.result = this.parseResult(payload);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Invalid transaction payload", e);
        }
    }

    public String getChannelName() {
        return this.channelName;
    }

    public ByteString getResult() {
        return this.result;
    }

    private String parseChannelName(Header header) throws InvalidProtocolBufferException {
        ChannelHeader channelHeader = ChannelHeader.parseFrom((ByteString)header.getChannelHeader());
        return channelHeader.getChannelId();
    }

    private ByteString parseResult(Payload payload) throws InvalidProtocolBufferException {
        Transaction transaction = Transaction.parseFrom((ByteString)payload.getData());
        ArrayList<InvalidProtocolBufferException> parseExceptions = new ArrayList<InvalidProtocolBufferException>();
        for (TransactionAction transactionAction : transaction.getActionsList()) {
            try {
                return this.parseResult(transactionAction);
            }
            catch (InvalidProtocolBufferException e) {
                parseExceptions.add(e);
            }
        }
        IllegalArgumentException e = new IllegalArgumentException("No proposal response found");
        parseExceptions.forEach(e::addSuppressed);
        throw e;
    }

    private ByteString parseResult(TransactionAction transactionAction) throws InvalidProtocolBufferException {
        ChaincodeActionPayload actionPayload = ChaincodeActionPayload.parseFrom((ByteString)transactionAction.getPayload());
        ProposalResponsePayload responsePayload = ProposalResponsePayload.parseFrom((ByteString)actionPayload.getAction().getProposalResponsePayload());
        ChaincodeAction chaincodeAction = ChaincodeAction.parseFrom((ByteString)responsePayload.getExtension());
        return chaincodeAction.getResponse().getPayload();
    }
}

