/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import org.hyperledger.fabric.client.GatewayUtils;
import org.hyperledger.fabric.client.Status;
import org.hyperledger.fabric.protos.gateway.CommitStatusResponse;
import org.hyperledger.fabric.protos.peer.TxValidationCode;

final class StatusImpl
implements Status {
    private final String transactionId;
    private final long blockNumber;
    private final TxValidationCode code;

    StatusImpl(String transactionId, CommitStatusResponse response) {
        this.transactionId = transactionId;
        this.blockNumber = response.getBlockNumber();
        this.code = response.getResult();
    }

    @Override
    public String getTransactionId() {
        return this.transactionId;
    }

    @Override
    public long getBlockNumber() {
        return this.blockNumber;
    }

    @Override
    public TxValidationCode getCode() {
        return this.code;
    }

    @Override
    public boolean isSuccessful() {
        return this.code == TxValidationCode.VALID;
    }

    public String toString() {
        return GatewayUtils.toString(this, "transactionId: " + this.transactionId, "code: " + this.code.getNumber() + " (" + this.code.name() + ")", "blockNumber: " + this.blockNumber);
    }
}

