/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.ByteString;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hyperledger.fabric.client.GatewayClient;
import org.hyperledger.fabric.client.GatewayUtils;
import org.hyperledger.fabric.client.Proposal;
import org.hyperledger.fabric.client.ProposalImpl;
import org.hyperledger.fabric.client.SigningIdentity;
import org.hyperledger.fabric.client.TransactionContext;
import org.hyperledger.fabric.protos.common.ChannelHeader;
import org.hyperledger.fabric.protos.common.Header;
import org.hyperledger.fabric.protos.common.HeaderType;
import org.hyperledger.fabric.protos.gateway.ProposedTransaction;
import org.hyperledger.fabric.protos.peer.ChaincodeHeaderExtension;
import org.hyperledger.fabric.protos.peer.ChaincodeID;
import org.hyperledger.fabric.protos.peer.ChaincodeInput;
import org.hyperledger.fabric.protos.peer.ChaincodeInvocationSpec;
import org.hyperledger.fabric.protos.peer.ChaincodeProposalPayload;
import org.hyperledger.fabric.protos.peer.ChaincodeSpec;
import org.hyperledger.fabric.protos.peer.SignedProposal;

final class ProposalBuilder
implements Proposal.Builder {
    private final GatewayClient client;
    private final SigningIdentity signingIdentity;
    private final String channelName;
    private final ChaincodeID chaincodeId;
    private final ChaincodeInput.Builder inputBuilder = ChaincodeInput.newBuilder();
    private final ChaincodeProposalPayload.Builder payloadBuilder = ChaincodeProposalPayload.newBuilder();
    private Set<String> endorsingOrgs = Collections.emptySet();

    ProposalBuilder(GatewayClient client, SigningIdentity signingIdentity, String channelName, String chaincodeName, String transactionName) {
        this.client = client;
        this.signingIdentity = signingIdentity;
        this.channelName = channelName;
        this.chaincodeId = ChaincodeID.newBuilder().setName(chaincodeName).build();
        this.inputBuilder.addArgs(ByteString.copyFrom((String)transactionName, (Charset)StandardCharsets.UTF_8));
    }

    @Override
    public ProposalBuilder addArguments(byte[] ... args) {
        for (byte[] arg : args) {
            this.inputBuilder.addArgs(ByteString.copyFrom((byte[])arg));
        }
        return this;
    }

    @Override
    public ProposalBuilder addArguments(String ... args) {
        for (String arg : args) {
            this.inputBuilder.addArgs(ByteString.copyFrom((String)arg, (Charset)StandardCharsets.UTF_8));
        }
        return this;
    }

    @Override
    public ProposalBuilder putAllTransient(Map<String, byte[]> transientData) {
        transientData.forEach(this::putTransient);
        return this;
    }

    @Override
    public ProposalBuilder putTransient(String key, byte[] value) {
        this.payloadBuilder.putTransientMap(key, ByteString.copyFrom((byte[])value));
        return this;
    }

    @Override
    public ProposalBuilder putTransient(String key, String value) {
        this.payloadBuilder.putTransientMap(key, ByteString.copyFromUtf8((String)value));
        return this;
    }

    @Override
    public ProposalBuilder setEndorsingOrganizations(String ... mspids) {
        this.endorsingOrgs = new HashSet<String>(Arrays.asList(mspids));
        return this;
    }

    @Override
    public Proposal build() {
        return new ProposalImpl(this.client, this.signingIdentity, this.channelName, this.newProposedTransaction());
    }

    private ProposedTransaction newProposedTransaction() {
        TransactionContext context = new TransactionContext(this.signingIdentity);
        return ProposedTransaction.newBuilder().setProposal(this.newSignedProposal(context)).setTransactionId(context.getTransactionId()).addAllEndorsingOrganizations(this.endorsingOrgs).build();
    }

    private SignedProposal newSignedProposal(TransactionContext context) {
        return SignedProposal.newBuilder().setProposalBytes(this.newProposal(context).toByteString()).build();
    }

    private org.hyperledger.fabric.protos.peer.Proposal newProposal(TransactionContext context) {
        return org.hyperledger.fabric.protos.peer.Proposal.newBuilder().setHeader(this.newHeader(context).toByteString()).setPayload(this.newChaincodeProposalPayload().toByteString()).build();
    }

    private Header newHeader(TransactionContext context) {
        return Header.newBuilder().setChannelHeader(this.newChannelHeader(context).toByteString()).setSignatureHeader(context.getSignatureHeader().toByteString()).build();
    }

    private ChannelHeader newChannelHeader(TransactionContext context) {
        return ChannelHeader.newBuilder().setType(HeaderType.ENDORSER_TRANSACTION.getNumber()).setTxId(context.getTransactionId()).setTimestamp(GatewayUtils.getCurrentTimestamp()).setChannelId(this.channelName).setExtension(this.newChaincodeHeaderExtension().toByteString()).setEpoch(0L).build();
    }

    private ChaincodeHeaderExtension newChaincodeHeaderExtension() {
        return ChaincodeHeaderExtension.newBuilder().setChaincodeId(this.chaincodeId).build();
    }

    private ChaincodeProposalPayload newChaincodeProposalPayload() {
        return this.payloadBuilder.setInput(this.newChaincodeInvocationSpec().toByteString()).build();
    }

    private ChaincodeInvocationSpec newChaincodeInvocationSpec() {
        return ChaincodeInvocationSpec.newBuilder().setChaincodeSpec(this.newChaincodeSpec()).build();
    }

    private ChaincodeSpec newChaincodeSpec() {
        return ChaincodeSpec.newBuilder().setChaincodeId(this.chaincodeId).setInput(this.inputBuilder.build()).build();
    }
}

