/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import java.util.Optional;
import java.util.OptionalLong;
import org.hyperledger.fabric.client.ChaincodeEvent;
import org.hyperledger.fabric.client.Checkpointer;

public final class InMemoryCheckpointer
implements Checkpointer {
    private OptionalLong blockNumber = OptionalLong.empty();
    private String transactionId;

    @Override
    public void checkpointBlock(long blockNumber) {
        this.checkpointTransaction(blockNumber + 1L, null);
    }

    @Override
    public void checkpointTransaction(long blockNumber, String transactionId) {
        this.blockNumber = OptionalLong.of(blockNumber);
        this.transactionId = transactionId;
    }

    @Override
    public void checkpointChaincodeEvent(ChaincodeEvent event) {
        this.checkpointTransaction(event.getBlockNumber(), event.getTransactionId());
    }

    @Override
    public OptionalLong getBlockNumber() {
        return this.blockNumber;
    }

    @Override
    public Optional<String> getTransactionId() {
        return Optional.ofNullable(this.transactionId);
    }
}

