/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import io.grpc.CallOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.hyperledger.fabric.client.CallOption;
import org.hyperledger.fabric.client.identity.Identity;
import org.hyperledger.fabric.protos.msp.SerializedIdentity;
import org.hyperledger.fabric.protos.orderer.SeekPosition;
import org.hyperledger.fabric.protos.orderer.SeekSpecified;

final class GatewayUtils {
    private GatewayUtils() {
    }

    public static String toString(Object o) {
        return o != null ? o.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(o)) : "null";
    }

    public static String toString(Object o, String ... additionalInfo) {
        return GatewayUtils.toString(o) + Arrays.stream(additionalInfo).collect(Collectors.joining(", ", "(", ")"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] concat(byte[] ... bytes) {
        int length = Arrays.stream(bytes).mapToInt(b -> ((byte[])b).length).sum();
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream(length);){
            for (byte[] b2 : bytes) {
                byteOut.write(b2);
            }
            byte[] byArray = byteOut.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] serializeIdentity(Identity identity) {
        return SerializedIdentity.newBuilder().setMspid(identity.getMspId()).setIdBytes(ByteString.copyFrom((byte[])identity.getCredentials())).build().toByteArray();
    }

    public static void requireNonNullArgument(Object value, String message) {
        if (null == value) {
            throw new IllegalArgumentException(message);
        }
    }

    public static Timestamp getCurrentTimestamp() {
        Instant now = Instant.now();
        return Timestamp.newBuilder().setSeconds(now.getEpochSecond()).setNanos(now.getNano()).build();
    }

    public static SeekPosition seekLargestBlockNumber() {
        SeekSpecified largestBlockNumber = SeekSpecified.newBuilder().setNumber(Long.MAX_VALUE).build();
        return SeekPosition.newBuilder().setSpecified(largestBlockNumber).build();
    }

    static UnaryOperator<CallOptions> asCallOptions(CallOption ... legacyOptions) {
        if (legacyOptions.length == 0) {
            return null;
        }
        return callOptions -> {
            for (CallOption operator : legacyOptions) {
                callOptions = operator.apply((CallOptions)callOptions);
            }
            return callOptions;
        };
    }
}

