/*
 * Decompiled with CFR 0.152.
 */
package org.hydev.logger.coloring;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.hydev.logger.HyLoggerUtilsKt;
import org.hydev.logger.coloring.GradientPoint;
import org.hydev.logger.format.AnsiColor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0006\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\b\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0006\"\u00020\b\u00a2\u0006\u0002\u0010\tB\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J*\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00120\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aJ\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u001c\u001a\u00020\u0014J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\u001c\u001a\u00020\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/hydev/logger/coloring/LinearGradient;", "", "c1", "Lorg/hydev/logger/coloring/GradientPoint;", "c2", "colors", "", "(Lorg/hydev/logger/coloring/GradientPoint;Lorg/hydev/logger/coloring/GradientPoint;[Lorg/hydev/logger/coloring/GradientPoint;)V", "Ljava/awt/Color;", "(Ljava/awt/Color;Ljava/awt/Color;[Ljava/awt/Color;)V", "", "(Ljava/util/List;)V", "colorText", "", "text", "degrees", "", "getColorPlane", "", "width", "", "height", "getColorWithRatio", "v1", "v2", "ratio", "", "getColors", "size", "getScaled", "HyLogger"})
public final class LinearGradient {
    private final List<GradientPoint> colors;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Color> getColors(int size) {
        ArrayList<Color> result = new ArrayList<Color>();
        List scaled = CollectionsKt.toMutableList((Collection)this.getScaled(size));
        GradientPoint c1 = (GradientPoint)scaled.remove(0);
        GradientPoint c2 = (GradientPoint)scaled.remove(0);
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void x;
            if (c2.getPos() == x) {
                result.add(c2.getColor());
                c1 = c2;
                c2 = (GradientPoint)scaled.remove(0);
            } else if (Intrinsics.areEqual((Object)c1, (Object)c2)) {
                result.add(c1.getColor());
            } else {
                float ratio = (float)(x - c1.getPos()) / (float)(c2.getPos() - c1.getPos());
                int r = this.getColorWithRatio(HyLoggerUtilsKt.getR(c1.getColor()), HyLoggerUtilsKt.getR(c2.getColor()), ratio);
                int g = this.getColorWithRatio(HyLoggerUtilsKt.getG(c1.getColor()), HyLoggerUtilsKt.getG(c2.getColor()), ratio);
                int b = this.getColorWithRatio(HyLoggerUtilsKt.getB(c1.getColor()), HyLoggerUtilsKt.getB(c2.getColor()), ratio);
                result.add(new Color(r, g, b));
            }
            ++x;
        }
        return result;
    }

    public final int getColorWithRatio(int v1, int v2, float ratio) {
        return (int)((float)v2 * ratio + (float)v1 * (1.0f - ratio));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GradientPoint> getScaled(int size) {
        void $this$mapTo$iv$iv;
        double scale = (double)size / (double)((GradientPoint)CollectionsKt.last(this.colors)).getPos();
        Iterable $this$map$iv = this.colors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GradientPoint gradientPoint = (GradientPoint)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            GradientPoint gradientPoint2 = new GradientPoint(it.getColor(), MathKt.roundToInt((double)((double)it.getPos() * scale)));
            collection.add(gradientPoint2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<List<Color>> getColorPlane(int width, int height, double degrees) {
        int n;
        double d = Math.toRadians(degrees);
        boolean bl = false;
        double slope = Math.tan(d);
        int yOffset = (int)(slope * (double)width);
        int yWithOffset = height + yOffset;
        boolean bl2 = false;
        int n2 = 0;
        ArrayList arrayList = new ArrayList(height);
        int n3 = 0;
        int n4 = 0;
        n4 = 0;
        int n5 = height;
        while (n4 < n5) {
            n = n4++;
            boolean bl3 = false;
            int n6 = n;
            ArrayList arrayList2 = arrayList;
            boolean bl4 = false;
            ArrayList arrayList3 = new ArrayList();
            arrayList2.add(arrayList3);
        }
        List colorPlane = arrayList;
        List<Color> verticalColors = this.getColors(yWithOffset);
        n2 = 0;
        int n7 = ((Collection)verticalColors).size();
        while (n2 < n7) {
            void sourceY;
            n3 = 0;
            n4 = width;
            if (n3 <= n4) {
                while (true) {
                    void x;
                    void actualY;
                    if (0 <= (n = (actualY = sourceY + (int)(slope * (double)x) - yOffset)) && height > n) {
                        ((ArrayList)colorPlane.get((int)actualY)).add(0, verticalColors.get((int)sourceY));
                    }
                    if (x == n4) break;
                    ++x;
                }
            }
            ++sourceY;
        }
        return colorPlane;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String colorText(@NotNull String text) {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        if (StringsKt.isBlank((CharSequence)text)) {
            return text;
        }
        List lines = StringsKt.lines((CharSequence)text);
        Iterable iterable = lines;
        LinearGradient linearGradient = this;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Integer n = HyLoggerUtilsKt.widthLength((String)it);
            collection.add(n);
        }
        collection = (List)destination$iv$iv;
        Comparable comparable = CollectionsKt.max((Iterable)collection);
        if (comparable == null) {
            Intrinsics.throwNpe();
        }
        List<Color> colors = linearGradient.getColors(((Number)((Object)comparable)).intValue());
        StringBuilder result = new StringBuilder();
        for (String line : lines) {
            int colorIndex = 0;
            CharSequence $this$forEach$iv = line;
            boolean $i$f$forEach = false;
            CharSequence charSequence = $this$forEach$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv;
                char c = element$iv = charSequence.charAt(i);
                boolean bl = false;
                result.append(HyLoggerUtilsKt.foreground(colors.get(colorIndex))).append(c);
                int n = colorIndex;
                colorIndex = n + 1;
                if (!HyLoggerUtilsKt.isFullWidth(c)) continue;
                n = colorIndex;
                colorIndex = n + 1;
            }
            result.append((Object)AnsiColor.RESET).append("\n");
        }
        String string = result.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return StringsKt.trimEnd((String)string, (char[])new char[]{'\n'});
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String colorText(@NotNull String text, double degrees) {
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        if (StringsKt.isBlank((CharSequence)text)) {
            return text;
        }
        List lines = StringsKt.lines((CharSequence)StringsKt.replace$default((String)text, (String)"\u0000", (String)"", (boolean)false, (int)4, null));
        Iterable $this$map$iv = lines;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = HyLoggerUtilsKt.widthLength((String)it);
            collection.add(object);
        }
        Comparable comparable = CollectionsKt.max((Iterable)((List)destination$iv$iv));
        if (comparable == null) {
            Intrinsics.throwNpe();
        }
        int width = ((Number)((Object)comparable)).intValue() - 1;
        List<List<Color>> colorPlane = this.getColorPlane(width, lines.size(), degrees);
        StringBuilder result = new StringBuilder();
        int $this$mapTo$iv$iv2 = 0;
        int n = ((Collection)lines).size();
        while ($this$mapTo$iv$iv2 < n) {
            void $this$mapTo$iv$iv3;
            void y;
            int colorIndex = 0;
            CharSequence $this$map$iv2 = (CharSequence)lines.get((int)y);
            boolean $i$f$map2 = false;
            CharSequence bl = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length());
            boolean $i$f$mapTo2 = false;
            void var17_23 = $this$mapTo$iv$iv3;
            for (int i = 0; i < var17_23.length(); ++i) {
                void c;
                char item$iv$iv;
                char c2 = item$iv$iv = var17_23.charAt(i);
                collection = destination$iv$iv2;
                boolean bl2 = false;
                String line = HyLoggerUtilsKt.foreground(colorPlane.get((int)y).get(colorIndex)) + (char)c;
                int n2 = colorIndex;
                colorIndex = n2 + 1;
                if (HyLoggerUtilsKt.isFullWidth((char)c)) {
                    n2 = colorIndex;
                    colorIndex = n2 + 1;
                }
                object = line;
                collection.add(object);
            }
            String one = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"", (CharSequence)"", (CharSequence)"", (int)0, null, null, (int)56, null);
            HyLoggerUtilsKt.line(result, one + (Object)((Object)AnsiColor.RESET)).toString();
            ++y;
        }
        String string = result.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return StringsKt.trimEnd((String)string, (char[])new char[]{'\n'});
    }

    public LinearGradient(@NotNull List<GradientPoint> colors) {
        Intrinsics.checkParameterIsNotNull(colors, (String)"colors");
        this.colors = colors;
        List<GradientPoint> $this$sortBy$iv = this.colors;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            List<GradientPoint> list = $this$sortBy$iv;
            boolean bl = false;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    GradientPoint it = (GradientPoint)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getPos());
                    it = (GradientPoint)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = it.getPos();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            CollectionsKt.sortWith(list, (Comparator)comparator);
        }
    }

    public LinearGradient(@NotNull GradientPoint c1, @NotNull GradientPoint c2, GradientPoint ... colors) {
        Intrinsics.checkParameterIsNotNull((Object)c1, (String)"c1");
        Intrinsics.checkParameterIsNotNull((Object)c2, (String)"c2");
        Intrinsics.checkParameterIsNotNull((Object)colors, (String)"colors");
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.add((Object)c1);
        spreadBuilder.add((Object)c2);
        spreadBuilder.addSpread((Object)colors);
        this(CollectionsKt.mutableListOf((Object[])((GradientPoint[])spreadBuilder.toArray((Object[])new GradientPoint[spreadBuilder.size()]))));
    }

    /*
     * WARNING - void declaration
     */
    public LinearGradient(@NotNull Color c1, @NotNull Color c2, Color ... colors) {
        Collection<GradientPoint> collection;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkParameterIsNotNull((Object)c1, (String)"c1");
        Intrinsics.checkParameterIsNotNull((Object)c2, (String)"c2");
        Intrinsics.checkParameterIsNotNull((Object)colors, (String)"colors");
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.add((Object)c1);
        spreadBuilder.add((Object)c2);
        spreadBuilder.addSpread((Object)colors);
        Iterable iterable = CollectionsKt.mutableListOf((Object[])((Color[])spreadBuilder.toArray((Object[])new Color[spreadBuilder.size()])));
        LinearGradient linearGradient = this;
        boolean $i$f$mapIndexed = false;
        void var6_7 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void it;
            int n = index$iv$iv++;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            Color color = (Color)item$iv$iv;
            int n3 = n2;
            collection = collection2;
            boolean bl2 = false;
            GradientPoint gradientPoint = new GradientPoint((Color)it, (int)(i * 10));
            collection.add(gradientPoint);
        }
        collection = (List)destination$iv$iv;
        linearGradient(CollectionsKt.toMutableList((Collection)collection));
    }
}

