/*
 * Decompiled with CFR 0.152.
 */
package org.hydev.logger.appenders;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.hydev.logger.HyLoggerConfig;
import org.hydev.logger.HyLoggerUtilsKt;
import org.hydev.logger.appenders.Appender;
import org.hydev.logger.appenders.ConsoleAppender$WhenMappings;
import org.hydev.logger.appenders.LogData;
import org.hydev.logger.format.AnsiColor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/hydev/logger/appenders/ConsoleAppender;", "Lorg/hydev/logger/appenders/Appender;", "()V", "logRaw", "", "message", "", "HyLogger"})
public final class ConsoleAppender
extends Appender {
    @Override
    public void logRaw(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        HyLoggerConfig.INSTANCE.getColorCompatibility().getLog().invoke((Object)message);
    }

    public ConsoleAppender() {
        super(null, 1, null);
        final String defaultFormat = HyLoggerUtilsKt.parseFormats("&f[&5%s&f] [&1%s&f] [%s&f] %s&r");
        final String fqcnFormat = HyLoggerUtilsKt.parseFormats("&f[&5%s&f] [&1%s&f] [%s&f(&e%s&f)] %s&r");
        this.setFormatter((Function1<? super LogData, String>)((Function1)new Function1<LogData, String>(){

            @NotNull
            public final String invoke(@NotNull LogData it) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String time = HyLoggerUtilsKt.now(HyLoggerConfig.INSTANCE.getTimePattern());
                switch (ConsoleAppender$WhenMappings.$EnumSwitchMapping$0[it.getLevel().ordinal()]) {
                    case 1: {
                        String string2 = defaultFormat;
                        Object[] objectArray = new Object[]{time, it.getPrefix(), (Object)((Object)AnsiColor.GREEN) + "INFO", (Object)((Object)AnsiColor.RESET) + it.getMsg()};
                        boolean bl = false;
                        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                        string = string3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(this, *args)");
                        break;
                    }
                    case 2: {
                        String string4 = defaultFormat;
                        Object[] objectArray = new Object[]{time, it.getPrefix(), (Object)((Object)AnsiColor.RED) + "WARNING", (Object)((Object)AnsiColor.YELLOW) + it.getMsg()};
                        boolean bl = false;
                        String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                        string = string5;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(this, *args)");
                        break;
                    }
                    case 3: {
                        String string6 = fqcnFormat;
                        Object[] objectArray = new Object[]{time, it.getPrefix(), (Object)((Object)AnsiColor.CYAN) + "DEBUG", it.getFqcn(), (Object)((Object)AnsiColor.CYAN) + it.getMsg()};
                        boolean bl = false;
                        String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
                        string = string7;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.String.format(this, *args)");
                        break;
                    }
                    case 4: {
                        String string8 = fqcnFormat;
                        Object[] objectArray = new Object[]{time, it.getPrefix(), (Object)((Object)AnsiColor.RED) + "ERROR", it.getFqcn(), (Object)((Object)AnsiColor.RED) + it.getMsg()};
                        boolean bl = false;
                        String string9 = String.format(string8, Arrays.copyOf(objectArray, objectArray.length));
                        string = string9;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"java.lang.String.format(this, *args)");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return string;
            }
        }));
    }
}

