/*
 * Decompiled with CFR 0.152.
 */
package org.hydev.logger;

import java.awt.Color;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.hydev.logger.HyLoggerConfig;
import org.hydev.logger.format.AnsiConstants;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\n*\u00020\u0002\u001a\n\u0010\f\u001a\u00020\r*\u00020\u000e\u001a\u001a\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011*\u00060\u0010j\u0002`\u00112\u0006\u0010\u000f\u001a\u00020\n\u001a\n\u0010\u0012\u001a\u00020\n*\u00020\u0013\u001a\n\u0010\u0014\u001a\u00020\n*\u00020\n\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0016\u001a\u00020\u0013*\u00020\n\u001a\n\u0010\u0017\u001a\u00020\u0001*\u00020\n\u001a\n\u0010\u0018\u001a\u00020\n*\u00020\n\u001a\n\u0010\u0019\u001a\u00020\n*\u00020\n\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\u00a8\u0006\u001a"}, d2={"b", "", "Ljava/awt/Color;", "getB", "(Ljava/awt/Color;)I", "g", "getG", "r", "getR", "background", "", "foreground", "isFullWidth", "", "", "line", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "now", "Ljava/time/format/DateTimeFormatter;", "parseFormats", "to8Bit", "toDatePattern", "widthLength", "withoutFormat", "withoutRGB", "HyLogger"})
public final class HyLoggerUtilsKt {
    @NotNull
    public static final String withoutFormat(@NotNull String $this$withoutFormat) {
        Intrinsics.checkParameterIsNotNull((Object)$this$withoutFormat, (String)"$this$withoutFormat");
        CharSequence charSequence = $this$withoutFormat;
        String string = "\u001b\\[[;\\d]*m";
        boolean bl = false;
        string = new Regex(string);
        String string2 = "";
        boolean bl2 = false;
        return string.replace(charSequence, string2);
    }

    @NotNull
    public static final String withoutRGB(@NotNull String $this$withoutRGB) {
        Intrinsics.checkParameterIsNotNull((Object)$this$withoutRGB, (String)"$this$withoutRGB");
        CharSequence charSequence = $this$withoutRGB;
        String string = "\u001b\\[38;[25];.*?m";
        boolean bl = false;
        string = new Regex(string);
        String string2 = "";
        boolean bl2 = false;
        return string.replace(charSequence, string2);
    }

    public static final int getR(@NotNull Color $this$r) {
        Intrinsics.checkParameterIsNotNull((Object)$this$r, (String)"$this$r");
        return $this$r.getRed();
    }

    public static final int getG(@NotNull Color $this$g) {
        Intrinsics.checkParameterIsNotNull((Object)$this$g, (String)"$this$g");
        return $this$g.getGreen();
    }

    public static final int getB(@NotNull Color $this$b) {
        Intrinsics.checkParameterIsNotNull((Object)$this$b, (String)"$this$b");
        return $this$b.getBlue();
    }

    public static final int to8Bit(@NotNull Color $this$to8Bit) {
        Intrinsics.checkParameterIsNotNull((Object)$this$to8Bit, (String)"$this$to8Bit");
        boolean grayPossible = true;
        boolean gray = false;
        float sep = 42.5f;
        while (grayPossible) {
            if ((float)HyLoggerUtilsKt.getR($this$to8Bit) < sep || (float)HyLoggerUtilsKt.getG($this$to8Bit) < sep || (float)HyLoggerUtilsKt.getB($this$to8Bit) < sep) {
                gray = (float)HyLoggerUtilsKt.getR($this$to8Bit) < sep && (float)HyLoggerUtilsKt.getG($this$to8Bit) < sep && (float)HyLoggerUtilsKt.getB($this$to8Bit) < sep;
                grayPossible = false;
            }
            sep += 42.5f;
        }
        return gray ? MathKt.roundToInt((float)(232.0f + (float)(HyLoggerUtilsKt.getR($this$to8Bit) + HyLoggerUtilsKt.getG($this$to8Bit) + HyLoggerUtilsKt.getB($this$to8Bit)) / 33.0f)) : 16 + (int)((float)HyLoggerUtilsKt.getR($this$to8Bit) / 256.0f * 6.0f) * 36 + (int)((float)HyLoggerUtilsKt.getG($this$to8Bit) / 256.0f * 6.0f) * 6 + (int)((float)HyLoggerUtilsKt.getB($this$to8Bit) / 256.0f * 6.0f);
    }

    @NotNull
    public static final String foreground(@NotNull Color $this$foreground) {
        Intrinsics.checkParameterIsNotNull((Object)$this$foreground, (String)"$this$foreground");
        return "\u001b[38;" + (String)HyLoggerConfig.INSTANCE.getColorMode().getFormat().invoke((Object)$this$foreground) + "m";
    }

    @NotNull
    public static final String background(@NotNull Color $this$background) {
        Intrinsics.checkParameterIsNotNull((Object)$this$background, (String)"$this$background");
        return "\u001b[48;" + (String)HyLoggerConfig.INSTANCE.getColorMode().getFormat().invoke((Object)$this$background) + "m";
    }

    @NotNull
    public static final DateTimeFormatter toDatePattern(@NotNull String $this$toDatePattern) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toDatePattern, (String)"$this$toDatePattern");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern($this$toDatePattern);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeFormatter, (String)"DateTimeFormatter.ofPattern(this)");
        return dateTimeFormatter;
    }

    @NotNull
    public static final String now(@NotNull DateTimeFormatter $this$now) {
        Intrinsics.checkParameterIsNotNull((Object)$this$now, (String)"$this$now");
        String string = LocalDateTime.now().format($this$now);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LocalDateTime.now().format(this)");
        return string;
    }

    @NotNull
    public static final StringBuilder line(@NotNull StringBuilder $this$line, @NotNull String line) {
        Intrinsics.checkParameterIsNotNull((Object)$this$line, (String)"$this$line");
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        StringBuilder stringBuilder = $this$line.append(line).append("\n");
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(line).append(\"\\n\")");
        return stringBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String parseFormats(@NotNull String $this$parseFormats) {
        Intrinsics.checkParameterIsNotNull((Object)$this$parseFormats, (String)"$this$parseFormats");
        String result = $this$parseFormats;
        Map<Character, String> $this$forEach$iv = AnsiConstants.INSTANCE.getFormatsIndex();
        boolean $i$f$forEach = false;
        Map<Character, String> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<Character, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void k;
            Map.Entry<Character, String> element$iv;
            Map.Entry<Character, String> $dstr$k$v = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<Character, String> entry = $dstr$k$v;
            boolean bl3 = false;
            char c = entry.getKey().charValue();
            entry = $dstr$k$v;
            bl3 = false;
            String v = entry.getValue();
            result = StringsKt.replace$default((String)result, (String)("&" + (char)k), (String)v, (boolean)false, (int)4, null);
        }
        return result;
    }

    public static final boolean isFullWidth(char $this$isFullWidth) {
        char c;
        char c2 = $this$isFullWidth;
        return c2 == '\u2329' || c2 == '\u232a' || c2 == '\u23f0' || c2 == '\u23f3' || c2 == '\u267f' || c2 == '\u2693' || c2 == '\u26a1' || c2 == '\u26ce' || c2 == '\u26d4' || c2 == '\u26ea' || c2 == '\u26f5' || c2 == '\u26fa' || c2 == '\u26fd' || c2 == '\u2705' || c2 == '\u2728' || c2 == '\u274c' || c2 == '\u274e' || c2 == '\u2757' || c2 == '\u27b0' || c2 == '\u27bf' || c2 == '\u2b50' || c2 == '\u2b55' || c2 == '\u3000' || c2 == '\u3004' || c2 == '\u3005' || c2 == '\u3006' || c2 == '\u3007' || c2 == '\u3008' || c2 == '\u3009' || c2 == '\u300a' || c2 == '\u300b' || c2 == '\u300c' || c2 == '\u300d' || c2 == '\u300e' || c2 == '\u300f' || c2 == '\u3010' || c2 == '\u3011' || c2 == '\u3014' || c2 == '\u3015' || c2 == '\u3016' || c2 == '\u3017' || c2 == '\u3018' || c2 == '\u3019' || c2 == '\u301a' || c2 == '\u301b' || c2 == '\u301c' || c2 == '\u301d' || c2 == '\u3020' || c2 == '\u3030' || c2 == '\u303b' || c2 == '\u303c' || c2 == '\u303d' || c2 == '\u303e' || c2 == '\u309f' || c2 == '\u30a0' || c2 == '\u30fb' || c2 == '\u30ff' || c2 == '\u3250' || c2 == '\ua015' || c2 == '\ufe17' || c2 == '\ufe18' || c2 == '\ufe19' || c2 == '\ufe30' || c2 == '\ufe35' || c2 == '\ufe36' || c2 == '\ufe37' || c2 == '\ufe38' || c2 == '\ufe39' || c2 == '\ufe3a' || c2 == '\ufe3b' || c2 == '\ufe3c' || c2 == '\ufe3d' || c2 == '\ufe3e' || c2 == '\ufe3f' || c2 == '\ufe40' || c2 == '\ufe41' || c2 == '\ufe42' || c2 == '\ufe43' || c2 == '\ufe44' || c2 == '\ufe47' || c2 == '\ufe48' || c2 == '\ufe58' || c2 == '\ufe59' || c2 == '\ufe5a' || c2 == '\ufe5b' || c2 == '\ufe5c' || c2 == '\ufe5d' || c2 == '\ufe5e' || c2 == '\ufe62' || c2 == '\ufe63' || c2 == '\ufe68' || c2 == '\ufe69' || c2 == '\uff04' || c2 == '\uff08' || c2 == '\uff09' || c2 == '\uff0a' || c2 == '\uff0b' || c2 == '\uff0c' || c2 == '\uff0d' || c2 == '\uff3b' || c2 == '\uff3c' || c2 == '\uff3d' || c2 == '\uff3e' || c2 == '\uff3f' || c2 == '\uff40' || c2 == '\uff5b' || c2 == '\uff5c' || c2 == '\uff5d' || c2 == '\uff5e' || c2 == '\uff5f' || c2 == '\uff60' || c2 == '\uffe2' || c2 == '\uffe3' || c2 == '\uffe4' || '\u1100' <= (c = c2) && '\u115f' >= c || '\u231a' <= (c = c2) && '\u231b' >= c || '\u23e9' <= (c = c2) && '\u23ec' >= c || '\u25fd' <= (c = c2) && '\u25fe' >= c || '\u2614' <= (c = c2) && '\u2615' >= c || '\u2648' <= (c = c2) && '\u2653' >= c || '\u26aa' <= (c = c2) && '\u26ab' >= c || '\u26bd' <= (c = c2) && '\u26be' >= c || '\u26c4' <= (c = c2) && '\u26c5' >= c || '\u26f2' <= (c = c2) && '\u26f3' >= c || '\u270a' <= (c = c2) && '\u270b' >= c || '\u2753' <= (c = c2) && '\u2755' >= c || '\u2795' <= (c = c2) && '\u2797' >= c || '\u2b1b' <= (c = c2) && '\u2b1c' >= c || '\u2e80' <= (c = c2) && '\u2e99' >= c || '\u2e9b' <= (c = c2) && '\u2ef3' >= c || '\u2f00' <= (c = c2) && '\u2fd5' >= c || '\u2ff0' <= (c = c2) && '\u2ffb' >= c || '\u3001' <= (c = c2) && '\u3003' >= c || '\u3012' <= (c = c2) && '\u3013' >= c || '\u301e' <= (c = c2) && '\u301f' >= c || '\u3021' <= (c = c2) && '\u3029' >= c || '\u302a' <= (c = c2) && '\u302d' >= c || '\u302e' <= (c = c2) && '\u302f' >= c || '\u3031' <= (c = c2) && '\u3035' >= c || '\u3036' <= (c = c2) && '\u3037' >= c || '\u3038' <= (c = c2) && '\u303a' >= c || '\u3041' <= (c = c2) && '\u3096' >= c || '\u3099' <= (c = c2) && '\u309a' >= c || '\u309b' <= (c = c2) && '\u309c' >= c || '\u309d' <= (c = c2) && '\u309e' >= c || '\u30a1' <= (c = c2) && '\u30fa' >= c || '\u30fc' <= (c = c2) && '\u30fe' >= c || '\u3105' <= (c = c2) && '\u312f' >= c || '\u3131' <= (c = c2) && '\u318e' >= c || '\u3190' <= (c = c2) && '\u3191' >= c || '\u3192' <= (c = c2) && '\u3195' >= c || '\u3196' <= (c = c2) && '\u319f' >= c || '\u31a0' <= (c = c2) && '\u31bf' >= c || '\u31c0' <= (c = c2) && '\u31e3' >= c || '\u31f0' <= (c = c2) && '\u31ff' >= c || '\u3200' <= (c = c2) && '\u321e' >= c || '\u3220' <= (c = c2) && '\u3229' >= c || '\u322a' <= (c = c2) && '\u3247' >= c || '\u3251' <= (c = c2) && '\u325f' >= c || '\u3260' <= (c = c2) && '\u327f' >= c || '\u3280' <= (c = c2) && '\u3289' >= c || '\u328a' <= (c = c2) && '\u32b0' >= c || '\u32b1' <= (c = c2) && '\u32bf' >= c || '\u32c0' <= (c = c2) && '\u32ff' >= c || '\u3300' <= (c = c2) && '\u33ff' >= c || '\u3400' <= (c = c2) && '\u4dbf' >= c || '\u4e00' <= (c = c2) && '\u9ffc' >= c || '\u9ffd' <= (c = c2) && '\u9fff' >= c || '\ua000' <= (c = c2) && '\ua014' >= c || '\ua016' <= (c = c2) && '\ua48c' >= c || '\ua490' <= (c = c2) && '\ua4c6' >= c || '\ua960' <= (c = c2) && '\ua97c' >= c || '\uac00' <= (c = c2) && '\ud7a3' >= c || '\uf900' <= (c = c2) && '\ufa6d' >= c || '\ufa6e' <= (c = c2) && '\ufa6f' >= c || '\ufa70' <= (c = c2) && '\ufad9' >= c || '\ufada' <= (c = c2) && '\ufaff' >= c || '\ufe10' <= (c = c2) && '\ufe16' >= c || '\ufe31' <= (c = c2) && '\ufe32' >= c || '\ufe33' <= (c = c2) && '\ufe34' >= c || '\ufe45' <= (c = c2) && '\ufe46' >= c || '\ufe49' <= (c = c2) && '\ufe4c' >= c || '\ufe4d' <= (c = c2) && '\ufe4f' >= c || '\ufe50' <= (c = c2) && '\ufe52' >= c || '\ufe54' <= (c = c2) && '\ufe57' >= c || '\ufe5f' <= (c = c2) && '\ufe61' >= c || '\ufe64' <= (c = c2) && '\ufe66' >= c || '\ufe6a' <= (c = c2) && '\ufe6b' >= c || '\uff01' <= (c = c2) && '\uff03' >= c || '\uff05' <= (c = c2) && '\uff07' >= c || '\uff0e' <= (c = c2) && '\uff0f' >= c || '\uff10' <= (c = c2) && '\uff19' >= c || '\uff1a' <= (c = c2) && '\uff1b' >= c || '\uff1c' <= (c = c2) && '\uff1e' >= c || '\uff1f' <= (c = c2) && '\uff20' >= c || '\uff21' <= (c = c2) && '\uff3a' >= c || '\uff41' <= (c = c2) && '\uff5a' >= c || '\uffe0' <= (c = c2) && '\uffe1' >= c || '\uffe5' <= (c = c2) && '\uffe6' >= c;
    }

    public static final int widthLength(@NotNull String $this$widthLength) {
        Intrinsics.checkParameterIsNotNull((Object)$this$widthLength, (String)"$this$widthLength");
        int len = $this$widthLength.length();
        CharSequence $this$forEach$iv = $this$widthLength;
        boolean $i$f$forEach = false;
        CharSequence charSequence = $this$forEach$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv;
            char it = element$iv = charSequence.charAt(i);
            boolean bl = false;
            if (!HyLoggerUtilsKt.isFullWidth(it)) continue;
            int n = len;
            len = n + 1;
        }
        return len;
    }
}

