/*
 * Decompiled with CFR 0.152.
 */
package org.hydev.logger;

import java.io.PrintStream;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.fusesource.jansi.AnsiConsole;
import org.hydev.logger.HyLoggerConfig;
import org.hydev.logger.HyLoggerUtilsKt;
import org.hydev.logger.appenders.Appender;
import org.hydev.logger.appenders.ColorCompatibility;
import org.hydev.logger.appenders.ConsoleAppender;
import org.hydev.logger.coloring.AnsiColorMode;
import org.hydev.logger.utils.HyPrintStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u000204R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0006\"\u0004\b.\u0010/R\u001a\u00100\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010)\"\u0004\b2\u0010+\u00a8\u00066"}, d2={"Lorg/hydev/logger/HyLoggerConfig;", "", "()V", "_originalErr", "Ljava/io/PrintStream;", "get_originalErr", "()Ljava/io/PrintStream;", "_originalOut", "get_originalOut", "appenders", "", "Lorg/hydev/logger/appenders/Appender;", "getAppenders", "()Ljava/util/List;", "colorCompatibility", "Lorg/hydev/logger/appenders/ColorCompatibility;", "getColorCompatibility", "()Lorg/hydev/logger/appenders/ColorCompatibility;", "setColorCompatibility", "(Lorg/hydev/logger/appenders/ColorCompatibility;)V", "colorMode", "Lorg/hydev/logger/coloring/AnsiColorMode;", "getColorMode", "()Lorg/hydev/logger/coloring/AnsiColorMode;", "setColorMode", "(Lorg/hydev/logger/coloring/AnsiColorMode;)V", "debug", "", "getDebug", "()Z", "setDebug", "(Z)V", "fileFormat", "", "getFileFormat", "()Ljava/lang/String;", "setFileFormat", "(Ljava/lang/String;)V", "fileTimePattern", "Ljava/time/format/DateTimeFormatter;", "getFileTimePattern", "()Ljava/time/format/DateTimeFormatter;", "setFileTimePattern", "(Ljava/time/format/DateTimeFormatter;)V", "out", "getOut", "setOut", "(Ljava/io/PrintStream;)V", "timePattern", "getTimePattern", "setTimePattern", "enableWindowsCmdCompatibility", "", "installSysOut", "HyLogger"})
public final class HyLoggerConfig {
    @NotNull
    private static AnsiColorMode colorMode;
    @NotNull
    private static ColorCompatibility colorCompatibility;
    @NotNull
    private static DateTimeFormatter timePattern;
    @NotNull
    private static final List<Appender> appenders;
    private static boolean debug;
    @NotNull
    private static DateTimeFormatter fileTimePattern;
    @NotNull
    private static String fileFormat;
    @NotNull
    private static PrintStream out;
    @NotNull
    private static final PrintStream _originalOut;
    @NotNull
    private static final PrintStream _originalErr;
    public static final HyLoggerConfig INSTANCE;

    @NotNull
    public final AnsiColorMode getColorMode() {
        return colorMode;
    }

    public final void setColorMode(@NotNull AnsiColorMode ansiColorMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)ansiColorMode), (String)"<set-?>");
        colorMode = ansiColorMode;
    }

    @NotNull
    public final ColorCompatibility getColorCompatibility() {
        return colorCompatibility;
    }

    public final void setColorCompatibility(@NotNull ColorCompatibility colorCompatibility) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)colorCompatibility), (String)"<set-?>");
        HyLoggerConfig.colorCompatibility = colorCompatibility;
    }

    @NotNull
    public final DateTimeFormatter getTimePattern() {
        return timePattern;
    }

    public final void setTimePattern(@NotNull DateTimeFormatter dateTimeFormatter) {
        Intrinsics.checkParameterIsNotNull((Object)dateTimeFormatter, (String)"<set-?>");
        timePattern = dateTimeFormatter;
    }

    @NotNull
    public final List<Appender> getAppenders() {
        return appenders;
    }

    public final boolean getDebug() {
        return debug;
    }

    public final void setDebug(boolean bl) {
        debug = bl;
    }

    @NotNull
    public final DateTimeFormatter getFileTimePattern() {
        return fileTimePattern;
    }

    public final void setFileTimePattern(@NotNull DateTimeFormatter dateTimeFormatter) {
        Intrinsics.checkParameterIsNotNull((Object)dateTimeFormatter, (String)"<set-?>");
        fileTimePattern = dateTimeFormatter;
    }

    @NotNull
    public final String getFileFormat() {
        return fileFormat;
    }

    public final void setFileFormat(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        fileFormat = string;
    }

    @NotNull
    public final PrintStream getOut() {
        return out;
    }

    public final void setOut(@NotNull PrintStream printStream) {
        Intrinsics.checkParameterIsNotNull((Object)printStream, (String)"<set-?>");
        out = printStream;
    }

    @NotNull
    public final PrintStream get_originalOut() {
        return _originalOut;
    }

    @NotNull
    public final PrintStream get_originalErr() {
        return _originalErr;
    }

    public final void installSysOut() {
        System.setOut(new HyPrintStream(_originalOut, (Function1<Object, Unit>)((Function1)installSysOut.1.INSTANCE)));
        System.setErr(new HyPrintStream(_originalErr, (Function1<Object, Unit>)((Function1)installSysOut.2.INSTANCE)));
    }

    public final void enableWindowsCmdCompatibility() {
        PrintStream printStream = AnsiConsole.out;
        Intrinsics.checkExpressionValueIsNotNull((Object)printStream, (String)"AnsiConsole.out");
        out = printStream;
        colorCompatibility = ColorCompatibility.PRESET_ONLY;
    }

    private HyLoggerConfig() {
    }

    static {
        HyLoggerConfig hyLoggerConfig;
        INSTANCE = hyLoggerConfig = new HyLoggerConfig();
        colorMode = AnsiColorMode.TRUE_COLOR_24BIT;
        colorCompatibility = ColorCompatibility.FORCED;
        timePattern = HyLoggerUtilsKt.toDatePattern("yyyy-MM-dd HH:mm:ss");
        appenders = CollectionsKt.mutableListOf((Object[])new Appender[]{new ConsoleAppender()});
        fileTimePattern = HyLoggerUtilsKt.toDatePattern("yy-MM-dd_HH-mm");
        fileFormat = "log-{name}@{time}.csv";
        PrintStream printStream = System.out;
        Intrinsics.checkExpressionValueIsNotNull((Object)printStream, (String)"System.out");
        out = printStream;
        PrintStream printStream2 = System.out;
        Intrinsics.checkExpressionValueIsNotNull((Object)printStream2, (String)"System.out");
        _originalOut = printStream2;
        PrintStream printStream3 = System.err;
        Intrinsics.checkExpressionValueIsNotNull((Object)printStream3, (String)"System.err");
        _originalErr = printStream3;
    }
}

