/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.xpath.impl;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.dom4j.Branch;
import org.dom4j.Node;
import org.dom4j.Text;

public class Trim {
    private static Map<Node, Node> trimmed = new WeakHashMap<Node, Node>();

    public static Node trimNode(Node node) {
        if (node instanceof Branch) {
            Trim.trimBranch((Branch)node);
        }
        return node;
    }

    public static void trimBranch(Branch branch) {
        Object obj;
        int i;
        if (trimmed.get(branch) != null) {
            return;
        }
        trimmed.put((Node)branch, (Node)branch);
        List content = branch.content();
        boolean first = true;
        int n = content.size();
        for (i = 0; i < n; ++i) {
            Object obj2 = content.get(i);
            if (obj2 instanceof Text) {
                Text text = (Text)obj2;
                if (!first) continue;
                String s = Trim.trimLeading(text.getText());
                text.setText(s);
                if (s.length() <= 0) continue;
                first = false;
                continue;
            }
            first = false;
            if (!(obj2 instanceof Branch)) continue;
            Trim.trimBranch((Branch)obj2);
        }
        for (i = content.size() - 1; i >= 0 && (obj = content.get(i)) instanceof Text; --i) {
            Text text = (Text)obj;
            String s = Trim.trimTrailing(text.getText());
            text.setText(s);
            if (s.length() > 0) break;
        }
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    private static String trimLeading(String s) {
        int m = s.length();
        int n = m;
        for (int i = 0; i < n; ++i) {
            if (Trim.isWhitespace(s.charAt(i))) continue;
            m = i;
            break;
        }
        return s.substring(m);
    }

    private static String trimTrailing(String s) {
        int max;
        int m = -1;
        for (int i = max = s.length() - 1; i >= 0; --i) {
            if (Trim.isWhitespace(s.charAt(i))) continue;
            m = i;
            break;
        }
        return s.substring(0, m + 1);
    }
}

