/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.model.Api;
import hudson.model.Messages;
import hudson.model.TimeSeries;
import hudson.util.ChartUtil;
import hudson.util.NoOverlapCategoryAxis;
import hudson.util.TimeUnit2;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class MultiStageTimeSeries {
    public final Localizable title;
    public final Color color;
    @Exported
    public final TimeSeries sec10;
    @Exported
    public final TimeSeries min;
    @Exported
    public final TimeSeries hour;
    private int counter;

    public MultiStageTimeSeries(Localizable title, Color color, float initialValue, float decay) {
        this.title = title;
        this.color = color;
        this.sec10 = new TimeSeries(initialValue, decay, 360);
        this.min = new TimeSeries(initialValue, decay, 1440);
        this.hour = new TimeSeries(initialValue, decay, 672);
    }

    public Localizable getTitle() {
        return this.title;
    }

    public Color getColor() {
        return this.color;
    }

    public TimeSeries getSec10() {
        return this.sec10;
    }

    public TimeSeries getMin() {
        return this.min;
    }

    public TimeSeries getHour() {
        return this.hour;
    }

    public MultiStageTimeSeries(float initialValue, float decay) {
        this(Messages._MultiStageTimeSeries_EMPTY_STRING(), Color.WHITE, initialValue, decay);
    }

    public void update(float f) {
        this.counter = (this.counter + 1) % 360;
        this.sec10.update(f);
        if (this.counter % 6 == 0) {
            this.min.update(f);
        }
        if (this.counter == 0) {
            this.hour.update(f);
        }
    }

    public TimeSeries pick(TimeScale timeScale) {
        switch (timeScale) {
            case HOUR: {
                return this.hour;
            }
            case MIN: {
                return this.min;
            }
            case SEC10: {
                return this.sec10;
            }
        }
        throw new AssertionError();
    }

    public float getLatest(TimeScale timeScale) {
        return this.pick(timeScale).getLatest();
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public static TrendChart createTrendChart(TimeScale scale, MultiStageTimeSeries ... data) {
        return new TrendChart(scale, data);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TrendChart
    implements HttpResponse {
        public final TimeScale timeScale;
        public final List<MultiStageTimeSeries> series;
        public final DefaultCategoryDataset dataset;

        public TimeScale getTimeScale() {
            return this.timeScale;
        }

        public List<MultiStageTimeSeries> getSeries() {
            return this.series;
        }

        public DefaultCategoryDataset getDataset() {
            return this.dataset;
        }

        public TrendChart(TimeScale timeScale, MultiStageTimeSeries ... series) {
            this.timeScale = timeScale;
            this.series = new ArrayList<MultiStageTimeSeries>(Arrays.asList(series));
            this.dataset = this.createDataset();
        }

        private DefaultCategoryDataset createDataset() {
            float[][] dataPoints = new float[this.series.size()][];
            for (int i = 0; i < this.series.size(); ++i) {
                dataPoints[i] = this.series.get(i).pick(this.timeScale).getHistory();
            }
            int dataLength = dataPoints[0].length;
            for (float[] dataPoint : dataPoints) {
                assert (dataLength == dataPoint.length);
            }
            DefaultCategoryDataset ds = new DefaultCategoryDataset();
            DateFormat format = this.timeScale.createDateFormat();
            Date dt = new Date(System.currentTimeMillis() - this.timeScale.tick * (long)dataLength);
            for (int i = dataLength - 1; i >= 0; --i) {
                dt = new Date(dt.getTime() + this.timeScale.tick);
                String l = format.format(dt);
                for (int j = 0; j < dataPoints.length; ++j) {
                    ds.addValue((double)dataPoints[j][i], (Comparable)((Object)this.series.get((int)j).title.toString()), (Comparable)((Object)l));
                }
            }
            return ds;
        }

        public JFreeChart createChart() {
            JFreeChart chart = ChartFactory.createLineChart(null, null, null, (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.white);
            CategoryPlot plot = chart.getCategoryPlot();
            plot.setBackgroundPaint((Paint)Color.WHITE);
            plot.setOutlinePaint(null);
            plot.setRangeGridlinesVisible(true);
            plot.setRangeGridlinePaint((Paint)Color.black);
            LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
            renderer.setBaseStroke((Stroke)new BasicStroke(3.0f));
            for (int i = 0; i < this.series.size(); ++i) {
                renderer.setSeriesPaint(i, (Paint)this.series.get((int)i).color);
            }
            NoOverlapCategoryAxis domainAxis = new NoOverlapCategoryAxis(null);
            plot.setDomainAxis((CategoryAxis)domainAxis);
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            domainAxis.setLowerMargin(0.0);
            domainAxis.setUpperMargin(0.0);
            domainAxis.setCategoryMargin(0.0);
            NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
            rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
            return chart;
        }

        public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
            ChartUtil.generateGraph(req, rsp, this.createChart(), 500, 400);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeScale {
        SEC10(TimeUnit2.SECONDS.toMillis(10L)),
        MIN(TimeUnit2.MINUTES.toMillis(1L)),
        HOUR(TimeUnit2.HOURS.toMillis(1L));

        public final long tick;

        private TimeScale(long tick) {
            this.tick = tick;
        }

        public DateFormat createDateFormat() {
            switch (this) {
                case HOUR: {
                    return new SimpleDateFormat("MMM/dd HH");
                }
                case MIN: {
                    return new SimpleDateFormat("HH:mm");
                }
                case SEC10: {
                    return new SimpleDateFormat("HH:mm:ss");
                }
            }
            throw new AssertionError();
        }

        public static TimeScale parse(String type) {
            if (type == null) {
                return MIN;
            }
            return Enum.valueOf(TimeScale.class, type.toUpperCase(Locale.ENGLISH));
        }
    }
}

