/*
 * Decompiled with CFR 0.152.
 */
package hudson.graph.jfreechart;

import org.jfree.chart.axis.NumberAxis;
import org.jfree.data.category.CategoryDataset;

public class Utils {
    public static double CHEBYSHEV_N = 3.0;

    public static void adjustChebyshev(CategoryDataset dataset, NumberAxis yAxis) {
        double sum = 0.0;
        double sum2 = 0.0;
        int nColumns = dataset.getColumnCount();
        int nRows = dataset.getRowCount();
        for (int i = 0; i < nRows; ++i) {
            Comparable rowKey = dataset.getRowKey(i);
            for (int j = 0; j < nColumns; ++j) {
                Comparable columnKey = dataset.getColumnKey(j);
                double n = dataset.getValue(rowKey, columnKey).doubleValue();
                sum += n;
                sum2 += n * n;
            }
        }
        double average = sum / (double)(nColumns * nRows);
        double stddev = Math.sqrt(sum2 / (double)(nColumns * nRows) - average * average);
        double rangeMin = average - stddev * CHEBYSHEV_N;
        double rangeMax = average + stddev * CHEBYSHEV_N;
        boolean found = false;
        double min = 0.0;
        double max = 0.0;
        for (int i = 0; i < nRows; ++i) {
            Comparable rowKey = dataset.getRowKey(i);
            for (int j = 0; j < nColumns; ++j) {
                Comparable columnKey = dataset.getColumnKey(j);
                double n = dataset.getValue(rowKey, columnKey).doubleValue();
                if (n < rangeMin || rangeMax < n) {
                    found = true;
                    continue;
                }
                min = Math.min(min, n);
                max = Math.max(max, n);
            }
        }
        if (!found) {
            return;
        }
        min = Math.min(0.0, min);
        max += yAxis.getUpperMargin() * (max - min);
        yAxis.setRange(min, max);
    }
}

