/*
 * Decompiled with CFR 0.152.
 */
package org.httpfeeds.server;

import java.time.Instant;
import java.util.List;
import org.httpfeeds.server.FeedItem;
import org.httpfeeds.server.FeedItemRowMapper;
import org.httpfeeds.server.FeedRepository;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
@ConditionalOnMissingBean
public class JdbcFeedRepository
implements FeedRepository {
    private final JdbcTemplate jdbcTemplate;
    private final FeedItemRowMapper feedItemRowMapper;
    private final String table;

    public JdbcFeedRepository(JdbcTemplate jdbcTemplate, FeedItemRowMapper feedItemRowMapper, @Value(value="${httpfeed.server.table}") String table) {
        this.jdbcTemplate = jdbcTemplate;
        this.feedItemRowMapper = feedItemRowMapper;
        this.table = table;
    }

    @Override
    public List<FeedItem> findByIdGreaterThan(String lastEventId, long limit) {
        if (lastEventId == null) {
            lastEventId = "";
        }
        String sql = String.format("select * from %s where id > ? order by id limit ?", this.table);
        return this.jdbcTemplate.query(sql, (RowMapper)this.feedItemRowMapper, new Object[]{lastEventId, limit});
    }

    @Override
    public void append(String id, String type, String source, Instant time, String subject, String method, String data) {
        String sql = String.format("insert into %s (id, type, source, time, subject, method, data) values (?, ?, ?, ?, ?, ?, ?)", this.table);
        this.jdbcTemplate.update(sql, new Object[]{id, type, source, time, subject, method, data});
    }

    public void deleteAll() {
        this.jdbcTemplate.update(String.format("delete from %s", this.table));
    }
}

