/*
 * Decompiled with CFR 0.152.
 */
package org.httpfeeds.server;

import java.util.List;
import java.util.stream.Collectors;
import org.httpfeeds.server.CloudEvent;
import org.httpfeeds.server.CloudEventMapper;
import org.httpfeeds.server.FeedFetcher;
import org.httpfeeds.server.FeedItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${httpfeed.server.path}"})
public class HttpFeedController {
    private static final Logger log = LoggerFactory.getLogger(HttpFeedController.class);
    private final FeedFetcher feedFetcher;

    public HttpFeedController(FeedFetcher feedFetcher) {
        this.feedFetcher = feedFetcher;
    }

    @GetMapping(produces={"application/cloudevents-batch+json", "application/json"})
    public List<CloudEvent> getFeedItems(@RequestParam(name="lastEventId", required=false) String lastEventId, @RequestParam(name="timeout", required=false) Long timeoutMillis) {
        log.debug("GET feed with lastEventId {}", (Object)lastEventId);
        List<FeedItem> items = timeoutMillis == null ? this.feedFetcher.fetch(lastEventId) : this.feedFetcher.fetchWithPolling(lastEventId, timeoutMillis);
        List<CloudEvent> cloudEvents = items.stream().map(CloudEventMapper::toCloudEvent).collect(Collectors.toList());
        log.debug("GET feed with lastEventId {} returned {} events", (Object)lastEventId, (Object)cloudEvents.size());
        return cloudEvents;
    }
}

