/*
 * Decompiled with CFR 0.152.
 */
package org.httpfeeds.server;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.httpfeeds.server.FeedItem;
import org.httpfeeds.server.FeedRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedFetcher {
    private static final Logger log = LoggerFactory.getLogger(FeedFetcher.class);
    private final FeedRepository feedRepository;
    private final Duration pollInterval;
    private final long limit;

    public FeedFetcher(FeedRepository feedRepository, Duration pollInterval, long limit) {
        this.feedRepository = feedRepository;
        this.pollInterval = pollInterval;
        this.limit = limit;
    }

    public List<FeedItem> fetch(String lastEventId) {
        log.debug("Find items with lastEventId={}", (Object)lastEventId);
        return this.feedRepository.findByIdGreaterThan(lastEventId, this.limit);
    }

    public List<FeedItem> fetchWithPolling(String lastEventId, Long timeoutMillis) {
        log.debug("Long polling for items with lastEventId={} timeoutMillis={}", (Object)lastEventId, (Object)timeoutMillis);
        Instant timeoutTimestamp = Instant.now().plus((long)timeoutMillis, ChronoUnit.MILLIS);
        while (true) {
            List<FeedItem> items;
            int numberOfItems;
            if ((numberOfItems = (items = this.feedRepository.findByIdGreaterThan(lastEventId, this.limit)).size()) > 0) {
                log.debug("Returning {} items.", (Object)numberOfItems);
                return items;
            }
            if (Instant.now().isAfter(timeoutTimestamp)) {
                log.debug("Polling timed out. Returning the empty response.");
                return items;
            }
            try {
                log.debug("No items found. Wait {} and then retry again.", (Object)this.pollInterval);
                Thread.sleep(this.pollInterval.toMillis());
            }
            catch (InterruptedException e) {
                log.debug("Thread was interrupted. Probably a graceful shutdown. Try to send response.");
                return items;
            }
        }
    }
}

