/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.client.internal;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Apply;
import cats.Defer;
import cats.Defer$;
import cats.FlatMap;
import cats.Foldable;
import cats.Functor;
import cats.Monad;
import cats.MonadError;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Clock;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Sync;
import cats.effect.kernel.Sync$;
import cats.effect.kernel.syntax.GenTemporalOps$;
import cats.effect.std.Hotswap;
import cats.effect.std.Hotswap$;
import cats.effect.syntax.package;
import cats.kernel.Eq;
import cats.package;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.ApplyOps$;
import cats.syntax.IfMOps$;
import cats.syntax.MonadErrorOps$;
import cats.syntax.MonadErrorRethrowOps$;
import cats.syntax.OptionOps$;
import cats.syntax.package;
import com.comcast.ip4s.Host;
import com.comcast.ip4s.Host$;
import com.comcast.ip4s.Port$;
import com.comcast.ip4s.SocketAddress;
import com.comcast.ip4s.SocketAddress$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.io.net.Socket;
import fs2.io.net.SocketGroup;
import fs2.io.net.SocketOption;
import fs2.io.net.tls.TLSContext;
import fs2.io.net.unixsocket.UnixSocketAddress;
import fs2.io.net.unixsocket.UnixSockets;
import java.io.Serializable;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeoutException;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpDate$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Uri;
import org.http4s.client.RequestKey;
import org.http4s.client.RequestKey$;
import org.http4s.ember.client.EmberConnection;
import org.http4s.ember.client.RequestKeySocket;
import org.http4s.ember.client.RequestKeySocket$;
import org.http4s.ember.client.internal.ClientHelpers;
import org.http4s.ember.client.internal.ClientHelpers$MissingOrInvalidHost$;
import org.http4s.ember.client.internal.ClientHelpers$MissingOrInvalidPort$;
import org.http4s.ember.client.internal.ClientHelpers$MissingTlsContext$;
import org.http4s.ember.client.internal.ClientHelpers$RetryLogic$;
import org.http4s.ember.core.EmberException;
import org.http4s.ember.core.Encoder$;
import org.http4s.ember.core.Parser;
import org.http4s.ember.core.Util$;
import org.http4s.headers.Connection;
import org.http4s.headers.Connection$;
import org.http4s.headers.Date;
import org.http4s.headers.Date$;
import org.http4s.headers.User;
import org.http4s.headers.User$minusAgent$;
import org.typelevel.ci.CIString;
import org.typelevel.ci.package$;
import org.typelevel.keypool.KeyPool;
import org.typelevel.keypool.Managed;
import org.typelevel.keypool.Reusable;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class ClientHelpers$
implements Serializable {
    public static final ClientHelpers$RetryLogic$ RetryLogic;
    private static final ClientHelpers$MissingOrInvalidHost$ MissingOrInvalidHost;
    private static final ClientHelpers$MissingOrInvalidPort$ MissingOrInvalidPort;
    private static final ClientHelpers$MissingTlsContext$ MissingTlsContext;
    public static final ClientHelpers$ MODULE$;

    private ClientHelpers$() {
    }

    static {
        MODULE$ = new ClientHelpers$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ClientHelpers$.class);
    }

    public <F> Resource<F, RequestKeySocket<F>> requestToSocketWithKey(Request<F> request, Option<TLSContext<F>> tlsContextOpt, boolean enableEndpointValidation, boolean enableServerNameIndication, SocketGroup<F> sg, List<SocketOption> additionalSocketOptions, MonadError<F, Throwable> evidence$1) {
        RequestKey requestKey = RequestKey$.MODULE$.fromRequest(request);
        return this.requestKeyToSocketWithKey(requestKey, tlsContextOpt, enableEndpointValidation, enableServerNameIndication, sg, additionalSocketOptions, evidence$1);
    }

    public <F> Resource<F, RequestKeySocket<F>> unixSocket(Request<F> request, UnixSockets<F> unixSockets, UnixSocketAddress address, Option<TLSContext<F>> tlsContextOpt, boolean enableEndpointValidation, boolean enableServerNameIndication, MonadError<F, Throwable> evidence$2) {
        RequestKey requestKey = RequestKey$.MODULE$.fromRequest(request);
        return this.elevateSocket(requestKey, unixSockets.client(address), tlsContextOpt, enableEndpointValidation, enableServerNameIndication, (Option<SocketAddress<Host>>)None$.MODULE$, evidence$2);
    }

    public <F> Resource<F, RequestKeySocket<F>> requestKeyToSocketWithKey(RequestKey requestKey, Option<TLSContext<F>> tlsContextOpt, boolean enableEndpointValidation, boolean enableServerNameIndication, SocketGroup<F> sg, List<SocketOption> additionalSocketOptions, MonadError<F, Throwable> evidence$3) {
        return Resource$.MODULE$.eval(this.getAddress(requestKey, evidence$3)).flatMap((Function1 & Serializable)address -> {
            Resource s = sg.client(address, additionalSocketOptions);
            return this.elevateSocket(requestKey, s, tlsContextOpt, enableEndpointValidation, enableServerNameIndication, (Option<SocketAddress<Host>>)Some$.MODULE$.apply(address), evidence$3);
        });
    }

    public <F> Resource<F, RequestKeySocket<F>> elevateSocket(RequestKey requestKey, Resource<F, Socket<F>> initSocket, Option<TLSContext<F>> tlsContextOpt, boolean enableEndpointValidation, boolean enableServerNameIndication, Option<SocketAddress<Host>> optionNames, MonadError<F, Throwable> evidence$4) {
        return initSocket.flatMap((Function1 & Serializable)iSocket -> {
            Resource resource;
            if (package.all$.MODULE$.catsSyntaxEq((Object)requestKey.scheme(), (Eq)Uri.Scheme$.MODULE$.http4sOrderForScheme()).$eq$eq$eq((Object)Uri.Scheme$.MODULE$.https())) {
                resource = (Resource)tlsContextOpt.fold(() -> this.elevateSocket$$anonfun$1$$anonfun$1(evidence$4), (Function1 & Serializable)_$5 -> (Resource)package.all$.MODULE$.toFunctorOps((Object)_$5.clientBuilder(iSocket).withParameters(Util$.MODULE$.mkClientTLSParameters(optionNames, enableEndpointValidation, enableServerNameIndication)).build(), (Functor)Resource$.MODULE$.catsEffectMonadErrorForResource(evidence$4)).widen());
            } else {
                Socket socket2 = (Socket)package.all$.MODULE$.catsSyntaxApplicativeId(iSocket);
                resource = (Resource)ApplicativeIdOps$.MODULE$.pure$extension((Object)socket2, (Applicative)Resource$.MODULE$.catsEffectMonadErrorForResource(evidence$4));
            }
            return resource.map((Function1 & Serializable)socket -> RequestKeySocket$.MODULE$.apply(socket, requestKey));
        });
    }

    public <F> Object request(Request<F> request, EmberConnection<F> connection, int chunkSize, int maxResponseHeaderSize, Duration idleTimeout, Duration timeout, Option<User.minusAgent> userAgent, Async<F> evidence$5) {
        Object object = package.all$.MODULE$.catsSyntaxMonadError(package.all$.MODULE$.toFlatMapOps(this.preprocessRequest(request, userAgent, (Monad<F>)evidence$5, (Clock<F>)evidence$5), evidence$5).flatMap((Function1 & Serializable)processedReq -> package.all$.MODULE$.toFunctorOps(this.writeRead$1(connection, chunkSize, maxResponseHeaderSize, idleTimeout, timeout, evidence$5, (Request)processedReq), (Functor)evidence$5).map((Function1 & Serializable)res -> res)), evidence$5);
        return MonadErrorOps$.MODULE$.adaptError$extension(object, (PartialFunction)new Serializable(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof EmberException.EmptyStream) {
                    EmberException.EmptyStream e = (EmberException.EmptyStream)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof EmberException.EmptyStream) {
                    EmberException.EmptyStream e = (EmberException.EmptyStream)throwable;
                    return new ClosedChannelException(e){
                        {
                            this.initCause((Throwable)e$1);
                        }

                        public String getMessage() {
                            return "Remote Disconnect: Received zero bytes after sending request";
                        }
                    };
                }
                return function1.apply((Object)x);
            }
        }, evidence$5);
    }

    public <F> Object preprocessRequest(Request<F> req, Option<User.minusAgent> userAgent, Monad<F> evidence$6, Clock<F> evidence$7) {
        Connection connection = (Connection)Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance())).fold(this::$anonfun$3, (Function1 & Serializable)x -> (Connection)Predef$.MODULE$.identity(x));
        Option userAgentHeader = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(User$minusAgent$.MODULE$.headerInstance())).orElse(() -> this.$anonfun$5(userAgent));
        return package.all$.MODULE$.toFunctorOps(Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Date$.MODULE$.headerInstance())).fold(() -> this.preprocessRequest$$anonfun$1(evidence$6, evidence$7), (Function1 & Serializable)_$14 -> {
            Date date = (Date)package.all$.MODULE$.catsSyntaxApplicativeId(_$14);
            return ApplicativeIdOps$.MODULE$.pure$extension((Object)date, (Applicative)evidence$6);
        }), evidence$6).map((Function1 & Serializable)date -> (Request)req.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw(date, Date$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)connection, Connection$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.foldablesToRaw((Object)userAgentHeader, (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForOption(), (Function1 & Serializable)h -> Header.ToRaw$.MODULE$.modelledHeadersToRaw(h, User$minusAgent$.MODULE$.headerInstance()))})));
    }

    public <F> Object postProcessResponse(Request<F> req, Response<F> resp, Object drain, Ref<F, byte[]> nextBytes, Ref<F, Reusable> canBeReused, Object startNextRead, GenConcurrent<F, Throwable> F) {
        return package.all$.MODULE$.toFlatMapOps(drain, F).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                byte[] bytes = (byte[])((Some)option).value();
                boolean requestClose = Util$.MODULE$.connectionFor(req.httpVersion(), req.headers()).hasClose();
                boolean responseClose = Util$.MODULE$.connectionFor(resp.httpVersion(), resp.headers()).hasClose();
                if (requestClose || responseClose) {
                    return F.unit();
                }
                Object object = package.all$.MODULE$.catsSyntaxApplyOps(nextBytes.set((Object)bytes));
                Object object2 = package.all$.MODULE$.catsSyntaxApplyOps(ApplyOps$.MODULE$.$times$greater$extension(object, startNextRead, (Apply)F));
                return ApplyOps$.MODULE$.$times$greater$extension(object2, canBeReused.set((Object)Reusable.Reuse$.MODULE$), (Apply)F);
            }
            if (None$.MODULE$.equals(option)) {
                return F.unit();
            }
            throw new MatchError((Object)option);
        });
    }

    private <F> Object getAddress(RequestKey requestKey, MonadError<F, Throwable> evidence$8) {
        RequestKey requestKey2 = requestKey;
        if (requestKey2 != null) {
            RequestKey requestKey3 = RequestKey$.MODULE$.unapply(requestKey2);
            Uri.Scheme scheme = requestKey3._1();
            Uri.Authority authority = requestKey3._2();
            Uri.Scheme s = scheme;
            Uri.Authority auth = authority;
            int port = BoxesRunTime.unboxToInt((Object)auth.port().getOrElse(() -> this.$anonfun$6(s)));
            String host2 = auth.host().value();
            Option option = package.all$.MODULE$.catsSyntaxOption(Host$.MODULE$.fromString(host2));
            return package.all$.MODULE$.toFlatMapOps(OptionOps$.MODULE$.liftTo$extension(option).apply(() -> this.getAddress$$anonfun$1(host2), evidence$8), evidence$8).flatMap((Function1 & Serializable)host -> {
                Option option = package.all$.MODULE$.catsSyntaxOption(Port$.MODULE$.fromInt(port));
                return package.all$.MODULE$.toFunctorOps(OptionOps$.MODULE$.liftTo$extension(option).apply(() -> this.getAddress$$anonfun$2$$anonfun$1(port), (ApplicativeError)evidence$8), (Functor)evidence$8).map((Function1 & Serializable)port -> SocketAddress$.MODULE$.apply(host, port));
            });
        }
        throw new MatchError((Object)requestKey2);
    }

    public <F> Resource<F, Managed<F, EmberConnection<F>>> getValidManaged(KeyPool<F, RequestKey, EmberConnection<F>> pool, Request<F> request, Async<F> evidence$9) {
        return Hotswap$.MODULE$.create(evidence$9).evalMap((Function1 & Serializable)hs -> this.go$1(pool, request, evidence$9, (Hotswap)hs));
    }

    private final Resource elevateSocket$$anonfun$1$$anonfun$1(MonadError evidence$4$2) {
        return Resource$.MODULE$.raiseError((Object)ClientHelpers$MissingTlsContext$.MODULE$.apply(), (ApplicativeError)evidence$4$2);
    }

    private final Object writeRequestToSocket$1(Duration idleTimeout$1, Async evidence$5$1, Request req, Socket socket) {
        return Encoder$.MODULE$.reqToBytes(req, Encoder$.MODULE$.reqToBytes$default$2(), (ApplicativeError)evidence$5$1).through((Function1 & Serializable)_$8 -> _$8.chunks().foreach((Function1 & Serializable)c -> Util$.MODULE$.timeoutMaybe(socket.write(c), idleTimeout$1, (GenTemporal)evidence$5$1))).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)evidence$5$1))).drain();
    }

    private final Object writeRead$1$$anonfun$1(Duration timeout$2, Async evidence$5$6) {
        return package.ApplicativeThrow$.MODULE$.apply((ApplicativeError)evidence$5$6).raiseError((Object)new TimeoutException(new StringBuilder(49).append("Timed Out on EmberClient Header Receive Timeout: ").append(timeout$2).toString()));
    }

    private final Object writeRead$1(EmberConnection connection$1, int chunkSize$1, int maxResponseHeaderSize$1, Duration idleTimeout$4, Duration timeout$1, Async evidence$5$4, Request req) {
        Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.writeRequestToSocket$1(idleTimeout$4, evidence$5$4, req, connection$1.keySocket().socket()));
        Object object2 = package.all$.MODULE$.catsSyntaxMonadErrorRethrow(package.all$.MODULE$.toFlatMapOps(connection$1.nextRead().get(), (FlatMap)evidence$5$4).flatMap((Function1 & Serializable)_$9 -> _$9.get()), (MonadError)evidence$5$4);
        Object object3 = package.all$.MODULE$.genTemporalOps(MonadErrorRethrowOps$.MODULE$.rethrow$extension(object2, (MonadError)evidence$5$4), (GenTemporal)evidence$5$4);
        Object parse = package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(connection$1.nextBytes().getAndSet((Object)Array$.MODULE$.emptyByteArray()), GenTemporalOps$.MODULE$.timeout$extension(object3, idleTimeout$4, (GenTemporal)evidence$5$4, (.less.colon.less)$less$colon$less$.MODULE$.refl()))).flatMapN((Function2 & Serializable)(head, firstRead) -> Parser.Response$.MODULE$.parser(maxResponseHeaderSize$1, (byte[])package.all$.MODULE$.toFoldableOps(firstRead, (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForOption()).foldLeft(head, (Function2 & Serializable)(_$10, _$11) -> Util$.MODULE$.concatBytes(_$10, _$11)), Util$.MODULE$.timeoutMaybe(connection$1.keySocket().socket().read(chunkSize$1), idleTimeout$4, (GenTemporal)evidence$5$4), (GenConcurrent)evidence$5$4), (FlatMap)evidence$5$4);
        return ApplyOps$.MODULE$.productR$extension(object, Util$.MODULE$.timeoutToMaybe(parse, timeout$1, Defer$.MODULE$.apply((Defer)evidence$5$4).defer(() -> this.writeRead$1$$anonfun$1(timeout$1, evidence$5$4)), (GenTemporal)evidence$5$4), (Apply)evidence$5$4);
    }

    private final Connection $anonfun$3() {
        return Connection$.MODULE$.apply(NonEmptyList$.MODULE$.of((Object)package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep-alive"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CIString[0])));
    }

    private final Option $anonfun$5(Option userAgent$1) {
        return userAgent$1;
    }

    private final Object preprocessRequest$$anonfun$1(Monad evidence$6$1, Clock evidence$7$1) {
        return package.all$.MODULE$.toFunctorOps(HttpDate$.MODULE$.current((Functor)evidence$6$1, evidence$7$1), (Functor)evidence$6$1).map((Function1 & Serializable)_$13 -> Date$.MODULE$.apply(_$13));
    }

    private final int $anonfun$6(Uri.Scheme s$1) {
        Uri.Scheme scheme = s$1;
        Uri.Scheme scheme2 = Uri.Scheme$.MODULE$.https();
        if (!(scheme != null ? !scheme.equals(scheme2) : scheme2 != null)) {
            return 443;
        }
        return 80;
    }

    private final ClientHelpers.MissingOrInvalidHost getAddress$$anonfun$1(String host$1) {
        return ClientHelpers$MissingOrInvalidHost$.MODULE$.apply(host$1);
    }

    private final ClientHelpers.MissingOrInvalidPort getAddress$$anonfun$2$$anonfun$1(int port$2) {
        return ClientHelpers$MissingOrInvalidPort$.MODULE$.apply(port$2);
    }

    private final Object go$1$$anonfun$1$$anonfun$1(Async evidence$9$4, Managed managed$1) {
        Managed managed = (Managed)package.all$.MODULE$.catsSyntaxApplicativeId((Object)managed$1);
        return ApplicativeIdOps$.MODULE$.pure$extension((Object)managed, (Applicative)evidence$9$4);
    }

    private final Object go$1$$anonfun$1$$anonfun$2(KeyPool pool$4, Request request$4, Async evidence$9$5, Hotswap hs$3, Managed managed$2) {
        if (managed$2.isReused()) {
            Object object = package.all$.MODULE$.catsSyntaxApplyOps(managed$2.canBeReused().set((Object)Reusable.DontReuse$.MODULE$));
            return ApplyOps$.MODULE$.$times$greater$extension(object, this.go$1(pool$4, request$4, evidence$9$5, hs$3), (Apply)evidence$9$5);
        }
        return Sync$.MODULE$.apply((Sync)evidence$9$5).raiseError((Object)new SocketException("Fresh connection from pool was not open"));
    }

    private final Object go$1(KeyPool pool$1, Request request$1, Async evidence$9$1, Hotswap hs$1) {
        Object object = package.all$.MODULE$.catsSyntaxApplyOps(hs$1.clear());
        return ApplyOps$.MODULE$.$times$greater$extension(object, package.all$.MODULE$.toFlatMapOps(hs$1.swap(pool$1.take((Object)RequestKey$.MODULE$.fromRequest(request$1))), (FlatMap)evidence$9$1).flatMap((Function1 & Serializable)managed -> {
            Object object = package.all$.MODULE$.catsSyntaxIfM(((EmberConnection)managed.value()).isValid(), (FlatMap)evidence$9$1);
            return IfMOps$.MODULE$.ifM$extension(object, () -> this.go$1$$anonfun$1$$anonfun$1(evidence$9$1, managed), () -> this.go$1$$anonfun$1$$anonfun$2(pool$1, request$1, evidence$9$1, hs$1, managed), (FlatMap)evidence$9$1);
        }), (Apply)evidence$9$1);
    }
}

