/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import org.http4s.blaze.http.http2.SessionCore;
import org.http4s.blaze.http.http2.WriteController;
import org.http4s.blaze.http.http2.WriteControllerImpl$Closed$;
import org.http4s.blaze.http.http2.WriteControllerImpl$Closing$;
import org.http4s.blaze.http.http2.WriteControllerImpl$Flushing$;
import org.http4s.blaze.http.http2.WriteControllerImpl$Idle$;
import org.http4s.blaze.http.http2.WriteInterest;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blaze.util.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class WriteControllerImpl
implements WriteController {
    private final SessionCore session;
    private final int highWaterMark;
    private final TailStage<ByteBuffer> tailStage;
    private final Logger logger;
    private final ArrayDeque<WriteInterest> interestedStreams;
    private final ArrayDeque<scala.collection.immutable.Seq<ByteBuffer>> pendingWrites;
    private State state;

    public WriteControllerImpl(SessionCore session, int highWaterMark, TailStage<ByteBuffer> tailStage) {
        this.session = session;
        this.highWaterMark = highWaterMark;
        this.tailStage = tailStage;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.blaze.http.http2.WriteControllerImpl");
        this.interestedStreams = new ArrayDeque();
        this.pendingWrites = new ArrayDeque();
        this.state = WriteControllerImpl$Idle$.MODULE$;
    }

    @Override
    public Future<BoxedUnit> close() {
        State state = this.state;
        if (WriteControllerImpl$Idle$.MODULE$.equals(state)) {
            this.state = WriteControllerImpl$Closed$.MODULE$;
            return package$.MODULE$.FutureUnit();
        }
        if (WriteControllerImpl$Flushing$.MODULE$.equals(state)) {
            Promise p = Promise$.MODULE$.apply();
            this.state = WriteControllerImpl$Closing$.MODULE$.apply((Promise<BoxedUnit>)p);
            return p.future();
        }
        if (state instanceof Closing) {
            Promise<BoxedUnit> promise;
            Closing closing = WriteControllerImpl$Closing$.MODULE$.unapply((Closing)state);
            Promise<BoxedUnit> p = promise = closing._1();
            return p.future();
        }
        if (WriteControllerImpl$Closed$.MODULE$.equals(state)) {
            return package$.MODULE$.FutureUnit();
        }
        throw new MatchError((Object)state);
    }

    private boolean pendingInterests() {
        return !this.pendingWrites.isEmpty() || !this.interestedStreams.isEmpty();
    }

    @Override
    public boolean write(scala.collection.immutable.Seq<ByteBuffer> data) {
        State state;
        block5: {
            block4: {
                state = this.state;
                if (WriteControllerImpl$Idle$.MODULE$.equals(state) || WriteControllerImpl$Flushing$.MODULE$.equals(state)) break block4;
                if (!(state instanceof Closing)) break block5;
                Closing closing = WriteControllerImpl$Closing$.MODULE$.unapply((Closing)state);
                Promise<BoxedUnit> promise = closing._1();
            }
            this.pendingWrites.addLast(data);
            this.maybeWrite();
            return true;
        }
        if (WriteControllerImpl$Closed$.MODULE$.equals(state)) {
            return false;
        }
        throw new MatchError((Object)state);
    }

    @Override
    public boolean write(ByteBuffer data) {
        return this.write((scala.collection.immutable.Seq<ByteBuffer>)scala.package$.MODULE$.Nil().$colon$colon((Object)data));
    }

    @Override
    public boolean registerWriteInterest(WriteInterest interest) {
        State state = this.state;
        if (WriteControllerImpl$Closed$.MODULE$.equals(state)) {
            return false;
        }
        this.interestedStreams.add(interest);
        this.maybeWrite();
        return true;
    }

    private void maybeWrite() {
        State state = this.state;
        WriteControllerImpl$Idle$ writeControllerImpl$Idle$ = WriteControllerImpl$Idle$.MODULE$;
        if (!(state != null ? !state.equals(writeControllerImpl$Idle$) : writeControllerImpl$Idle$ != null)) {
            this.state = WriteControllerImpl$Flushing$.MODULE$;
            this.doWrite();
            return;
        }
    }

    private int addDirectWrites(ArrayBuffer<ByteBuffer> dest) {
        int written = 0;
        while (!this.pendingWrites.isEmpty()) {
            written += this.addBuffs(dest, (Seq<ByteBuffer>)((Seq)this.pendingWrites.poll()));
        }
        return written;
    }

    private int addBuffs(ArrayBuffer<ByteBuffer> dest, Seq<ByteBuffer> data) {
        IntRef written = IntRef.create((int)0);
        data.foreach((Function1)(JProcedure1 & Serializable)buf -> {
            int rem = buf.remaining();
            if (0 < rem) {
                written$1.elem += rem;
                dest.$plus$eq(buf);
                return;
            }
        });
        return written.elem;
    }

    private void doWrite() {
        ArrayBuffer toWrite = new ArrayBuffer();
        int bytesToWrite = this.addDirectWrites((ArrayBuffer<ByteBuffer>)toWrite);
        while (!this.interestedStreams.isEmpty() && bytesToWrite < this.highWaterMark) {
            try {
                Seq<ByteBuffer> data = this.interestedStreams.poll().performStreamWrite();
                bytesToWrite += this.addBuffs((ArrayBuffer<ByteBuffer>)toWrite, data);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable t = throwable3 = (Throwable)option.get();
                    Logger Logger_this = this.logger;
                    if (!Logger_this.isErrorEnabled()) continue;
                    Logger_this.error("Unhandled exception performing stream write operation", t);
                    continue;
                }
                throw throwable;
            }
        }
        Logger Logger_this = this.logger;
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(21).append("Flushing ").append(bytesToWrite).append(" to the wire").toString());
        }
        this.tailStage.channelWrite((Seq)toWrite).onComplete((Function1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                State state = this.state;
                if (WriteControllerImpl$Idle$.MODULE$.equals(state)) {
                    throw new IllegalStateException("Write finished to find Idle state");
                }
                if (WriteControllerImpl$Flushing$.MODULE$.equals(state)) {
                    if (this.pendingInterests()) {
                        this.doWrite();
                        return BoxedUnit.UNIT;
                    }
                    this.state = WriteControllerImpl$Idle$.MODULE$;
                    return BoxedUnit.UNIT;
                }
                if (state instanceof Closing) {
                    Closing closing = WriteControllerImpl$Closing$.MODULE$.unapply((Closing)state);
                    Promise<BoxedUnit> promise = closing._1();
                    if (this.pendingInterests()) {
                        this.doWrite();
                        return BoxedUnit.UNIT;
                    }
                    Promise<BoxedUnit> p = promise;
                    this.state = WriteControllerImpl$Closed$.MODULE$;
                    return p.success((Object)BoxedUnit.UNIT);
                }
                if (WriteControllerImpl$Closed$.MODULE$.equals(state)) {
                    throw new IllegalStateException("Shouldn't get here");
                }
                throw new MatchError((Object)state);
            }
            if (try_ instanceof Failure) {
                Throwable t = ((Failure)try_).exception();
                this.session.invokeShutdownWithError((Option<Throwable>)Some$.MODULE$.apply((Object)t), "WriteController.doWrite");
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)try_);
        }, this.session.serialExecutor());
    }

    public static class Closing
    implements State,
    Product,
    Serializable {
        private final Promise p;

        public static Closing apply(Promise<BoxedUnit> promise) {
            return WriteControllerImpl$Closing$.MODULE$.apply(promise);
        }

        public static Closing fromProduct(Product product) {
            return WriteControllerImpl$Closing$.MODULE$.fromProduct(product);
        }

        public static Closing unapply(Closing closing) {
            return WriteControllerImpl$Closing$.MODULE$.unapply(closing);
        }

        public Closing(Promise<BoxedUnit> p) {
            this.p = p;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Closing)) return false;
            Closing closing = (Closing)object;
            Promise<BoxedUnit> promise = this.p();
            Promise<BoxedUnit> promise2 = closing.p();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            if (!closing.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Closing;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Closing";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "p";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Promise<BoxedUnit> p() {
            return this.p;
        }

        public Closing copy(Promise<BoxedUnit> p) {
            return new Closing(p);
        }

        public Promise<BoxedUnit> copy$default$1() {
            return this.p();
        }

        public Promise<BoxedUnit> _1() {
            return this.p();
        }
    }

    public static interface State {
    }
}

