/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.http4s.blaze.http.http2.PingManager$;
import org.http4s.blaze.http.http2.PingManager$Closed$;
import org.http4s.blaze.http.http2.PingManager$Idle$;
import org.http4s.blaze.http.http2.PingManager$Pinging$;
import org.http4s.blaze.http.http2.SessionCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.Product;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class PingManager {
    private final SessionCore session;
    private final Logger logger;
    private State state;

    public PingManager(SessionCore session) {
        this.session = session;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.blaze.http.http2.PingManager");
        this.state = PingManager$Idle$.MODULE$;
    }

    public Future<Duration> ping() {
        long time = System.currentTimeMillis();
        State state = this.state;
        if (PingManager$Idle$.MODULE$.equals(state)) {
            byte[] data = new byte[8];
            ByteBuffer.wrap(data).putLong(time);
            ByteBuffer pingFrame = this.session.http2Encoder().pingFrame(data);
            if (this.session.writeController().write(pingFrame)) {
                Logger Logger_this = this.logger;
                if (Logger_this.isDebugEnabled()) {
                    Logger_this.debug(new StringBuilder(18).append("PING initiated at ").append(time).toString());
                }
                Promise p = Promise$.MODULE$.apply();
                this.state = PingManager$Pinging$.MODULE$.apply(time, (Promise<Duration>)p);
                return p.future();
            }
            Exception ex = new Exception("Socket closed");
            this.state = PingManager$Closed$.MODULE$.apply(ex);
            return Future$.MODULE$.failed((Throwable)ex);
        }
        if (state instanceof Pinging) {
            Pinging pinging = PingManager$Pinging$.MODULE$.unapply((Pinging)state);
            long l = pinging._1();
            Promise<Duration> promise = pinging._2();
            IllegalStateException ex = new IllegalStateException("Ping already in progress");
            return Future$.MODULE$.failed((Throwable)ex);
        }
        if (state instanceof Closed) {
            Exception exception;
            Closed closed = PingManager$Closed$.MODULE$.unapply((Closed)state);
            Exception ex = exception = closed._1();
            return Future$.MODULE$.failed((Throwable)ex);
        }
        throw new MatchError((Object)state);
    }

    public void pingAckReceived(byte[] data) {
        State state = this.state;
        if (state instanceof Pinging) {
            Pinging pinging = PingManager$Pinging$.MODULE$.unapply((Pinging)state);
            long l = pinging._1();
            Promise<Duration> promise = pinging._2();
            long sent = l;
            Promise<Duration> continuation = promise;
            this.state = PingManager$Idle$.MODULE$;
            if (ByteBuffer.wrap(data).getLong() != sent) {
                String msg = "Received ping response with unknown data.";
                Exception ex = new Exception(msg);
                Logger Logger_this = this.logger;
                if (Logger_this.isWarnEnabled()) {
                    Logger_this.warn(msg, (Throwable)ex);
                }
                continuation.tryFailure((Throwable)ex);
                return;
            }
            FiniteDuration duration = Duration$.MODULE$.create(package$.MODULE$.max(0L, System.currentTimeMillis() - sent), TimeUnit.MILLISECONDS);
            Logger Logger_this = this.logger;
            if (Logger_this.isDebugEnabled()) {
                Logger_this.debug(new StringBuilder(15).append("Ping duration: ").append(duration).toString());
            }
            continuation.trySuccess((Object)duration);
            return;
        }
        State other = state;
        Logger Logger_this = this.logger;
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(20).append("Ping ACKed in state ").append(other).toString());
            return;
        }
    }

    public void close() {
        State state = this.state;
        if (state instanceof Closed) {
            Closed closed = PingManager$Closed$.MODULE$.unapply((Closed)state);
            Exception exception = closed._1();
            return;
        }
        if (PingManager$Idle$.MODULE$.equals(state)) {
            this.state = PingManager$.org$http4s$blaze$http$http2$PingManager$$$GracefulClosed;
            return;
        }
        if (state instanceof Pinging) {
            Promise<Duration> promise;
            Pinging pinging = PingManager$Pinging$.MODULE$.unapply((Pinging)state);
            long l = pinging._1();
            Promise<Duration> p = promise = pinging._2();
            this.state = PingManager$.org$http4s$blaze$http$http2$PingManager$$$GracefulClosed;
            p.failure((Throwable)new Exception("PING interrupted"));
            return;
        }
        throw new MatchError((Object)state);
    }

    public static class Closed
    implements State,
    Product,
    Serializable {
        private final Exception ex;

        public static Closed apply(Exception exception) {
            return PingManager$Closed$.MODULE$.apply(exception);
        }

        public static Closed fromProduct(Product product) {
            return PingManager$Closed$.MODULE$.fromProduct(product);
        }

        public static Closed unapply(Closed closed) {
            return PingManager$Closed$.MODULE$.unapply(closed);
        }

        public Closed(Exception ex) {
            this.ex = ex;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Closed)) return false;
            Closed closed = (Closed)object;
            Exception exception = this.ex();
            Exception exception2 = closed.ex();
            if (exception == null) {
                if (exception2 != null) {
                    return false;
                }
            } else if (!exception.equals(exception2)) return false;
            if (!closed.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Closed;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Closed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ex";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Exception ex() {
            return this.ex;
        }

        public Closed copy(Exception ex) {
            return new Closed(ex);
        }

        public Exception copy$default$1() {
            return this.ex();
        }

        public Exception _1() {
            return this.ex();
        }
    }

    public static class Pinging
    implements State,
    Product,
    Serializable {
        private final long started;
        private final Promise p;

        public static Pinging apply(long l, Promise<Duration> promise) {
            return PingManager$Pinging$.MODULE$.apply(l, promise);
        }

        public static Pinging fromProduct(Product product) {
            return PingManager$Pinging$.MODULE$.fromProduct(product);
        }

        public static Pinging unapply(Pinging pinging) {
            return PingManager$Pinging$.MODULE$.unapply(pinging);
        }

        public Pinging(long started, Promise<Duration> p) {
            this.started = started;
            this.p = p;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.started()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.p()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Pinging)) return false;
            Pinging pinging = (Pinging)object;
            if (this.started() != pinging.started()) return false;
            Promise<Duration> promise = this.p();
            Promise<Duration> promise2 = pinging.p();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            if (!pinging.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Pinging;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Pinging";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToLong((long)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "started";
            }
            if (1 == n2) {
                return "p";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long started() {
            return this.started;
        }

        public Promise<Duration> p() {
            return this.p;
        }

        public Pinging copy(long started, Promise<Duration> p) {
            return new Pinging(started, p);
        }

        public long copy$default$1() {
            return this.started();
        }

        public Promise<Duration> copy$default$2() {
            return this.p();
        }

        public long _1() {
            return this.started();
        }

        public Promise<Duration> _2() {
            return this.p();
        }
    }

    public static interface State {
    }
}

