/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.parser;

import org.http4s.blaze.http.parser.BaseExceptions;

public final class HttpTokens {
    static final char EMPTY_BUFF = '\uffff';
    static final char REPLACEMENT = '\ufffd';
    static final char COLON = ':';
    static final char TAB = '\t';
    static final char LF = '\n';
    static final char CR = '\r';
    static final char SPACE = ' ';
    static final char[] CRLF = new char[]{'\r', '\n'};
    static final char SEMI_COLON = ';';
    static final byte ZERO = 48;
    static final byte NINE = 57;
    static final byte A = 65;
    static final byte F = 70;
    static final byte Z = 90;
    static final byte a = 97;
    static final byte f = 102;
    static final byte z = 122;

    public static int hexCharToInt(char c) throws BaseExceptions.BadCharacter {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new BaseExceptions.BadCharacter("Bad hex char: " + c);
    }

    public static boolean isDigit(char c) {
        return '9' >= c && c >= '0';
    }

    public static boolean isHexChar(byte by) {
        return 48 <= by && by <= 57 || 97 <= by && by <= 102 || 65 <= by && by <= 70;
    }

    public static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t';
    }
}

