/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.http4s.blaze.http.http2.Continue$;
import org.http4s.blaze.http.http2.Error;
import org.http4s.blaze.http.http2.Error$;
import org.http4s.blaze.http.http2.FrameDecoder$;
import org.http4s.blaze.http.http2.FrameListener;
import org.http4s.blaze.http.http2.HeaderAggregatingFrameListener$PHeaders$;
import org.http4s.blaze.http.http2.HeaderAggregatingFrameListener$PPromise$;
import org.http4s.blaze.http.http2.HeaderDecoder;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2Settings;
import org.http4s.blaze.http.http2.MaybeError;
import org.http4s.blaze.http.http2.Priority;
import org.http4s.blaze.http.http2.Result;
import org.http4s.blaze.util.BufferTools$;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class HeaderAggregatingFrameListener
implements FrameListener {
    private final Http2Settings localSettings;
    private final HeaderDecoder headerDecoder;
    public final HeaderAggregatingFrameListener$PHeaders$ PHeaders$lzy1;
    public final HeaderAggregatingFrameListener$PPromise$ PPromise$lzy1;
    private PartialFrame hInfo;

    public HeaderAggregatingFrameListener(Http2Settings localSettings, HeaderDecoder headerDecoder) {
        this.localSettings = localSettings;
        this.headerDecoder = headerDecoder;
        this.PHeaders$lzy1 = new HeaderAggregatingFrameListener$PHeaders$(this);
        this.PPromise$lzy1 = new HeaderAggregatingFrameListener$PPromise$(this);
        this.hInfo = null;
    }

    private final HeaderAggregatingFrameListener$PHeaders$ PHeaders() {
        return this.PHeaders$lzy1;
    }

    private final HeaderAggregatingFrameListener$PPromise$ PPromise() {
        return this.PPromise$lzy1;
    }

    public abstract Result onCompleteHeadersFrame(int var1, Priority var2, boolean var3, Seq<Tuple2<String, String>> var4);

    public abstract Result onCompletePushPromiseFrame(int var1, int var2, Seq<Tuple2<String, String>> var3);

    public final void setMaxHeaderTableSize(int maxSize) {
        this.headerDecoder.setMaxHeaderTableSize(maxSize);
    }

    @Override
    public final boolean inHeaderSequence() {
        return this.hInfo != null;
    }

    @Override
    public final Result onHeadersFrame(int streamId, Priority priority, boolean endHeaders, boolean endStream, ByteBuffer buffer) {
        if (this.inHeaderSequence()) {
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringBuilder(63).append("Received HEADERS frame while in in headers sequence. Stream id ").append(FrameDecoder$.MODULE$.hexStr(streamId)).toString()));
        }
        if (buffer.remaining() > this.localSettings.maxHeaderListSize()) {
            return this.headerSizeError(buffer.remaining(), streamId);
        }
        if (endHeaders) {
            MaybeError r = this.headerDecoder.decode(buffer, streamId, true);
            if (!r.success()) {
                return r;
            }
            scala.collection.immutable.Seq<Tuple2<String, String>> hs = this.headerDecoder.finish();
            return this.onCompleteHeadersFrame(streamId, priority, endStream, (Seq<Tuple2<String, String>>)hs);
        }
        this.hInfo = this.PHeaders().apply(streamId, priority, endStream, buffer);
        return Continue$.MODULE$;
    }

    @Override
    public final Result onPushPromiseFrame(int streamId, int promisedId, boolean endHeaders, ByteBuffer buffer) {
        if (this.localSettings.maxHeaderListSize() < buffer.remaining()) {
            return this.headerSizeError(buffer.remaining(), streamId);
        }
        if (endHeaders) {
            MaybeError r = this.headerDecoder.decode(buffer, streamId, true);
            if (!r.success()) {
                return r;
            }
            scala.collection.immutable.Seq<Tuple2<String, String>> hs = this.headerDecoder.finish();
            return this.onCompletePushPromiseFrame(streamId, promisedId, (Seq<Tuple2<String, String>>)hs);
        }
        this.hInfo = this.PPromise().apply(streamId, promisedId, buffer);
        return Continue$.MODULE$;
    }

    @Override
    public final Result onContinuationFrame(int streamId, boolean endHeaders, ByteBuffer buffer) {
        if (this.hInfo.streamId() != streamId) {
            String msg = new StringBuilder(53).append("Invalid CONTINUATION frame: stream Id's don't match. ").append(new StringBuilder(20).append("Expected ").append(this.hInfo.streamId()).append(", received ").append(streamId).toString()).toString();
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(msg));
        }
        int totalSize = buffer.remaining() + this.hInfo.buffer().remaining();
        if (this.localSettings.maxHeaderListSize() < totalSize) {
            return this.headerSizeError(totalSize, streamId);
        }
        ByteBuffer newBuffer = BufferTools$.MODULE$.concatBuffers(this.hInfo.buffer(), buffer);
        if (endHeaders) {
            MaybeError r = this.headerDecoder.decode(newBuffer, streamId, true);
            if (!r.success()) {
                return r;
            }
            scala.collection.immutable.Seq<Tuple2<String, String>> hs = this.headerDecoder.finish();
            PartialFrame i = this.hInfo;
            this.hInfo = null;
            PartialFrame partialFrame = i;
            if (partialFrame instanceof PHeaders && ((PHeaders)partialFrame).org$http4s$blaze$http$http2$HeaderAggregatingFrameListener$PHeaders$$$outer() == this) {
                PHeaders pHeaders = this.PHeaders().unapply((PHeaders)partialFrame);
                int n = pHeaders._1();
                Priority priority = pHeaders._2();
                boolean bl = pHeaders._3();
                ByteBuffer byteBuffer = pHeaders._4();
                int sid = n;
                Priority pri = priority;
                boolean es = bl;
                return this.onCompleteHeadersFrame(sid, pri, es, (Seq<Tuple2<String, String>>)hs);
            }
            if (partialFrame instanceof PPromise && ((PPromise)partialFrame).org$http4s$blaze$http$http2$HeaderAggregatingFrameListener$PPromise$$$outer() == this) {
                PPromise pPromise = this.PPromise().unapply((PPromise)partialFrame);
                int n = pPromise._1();
                int n2 = pPromise._2();
                ByteBuffer byteBuffer = pPromise._3();
                int sid = n;
                int pro = n2;
                return this.onCompletePushPromiseFrame(sid, pro, (Seq<Tuple2<String, String>>)hs);
            }
            throw new MatchError((Object)partialFrame);
        }
        this.hInfo.buffer_$eq(newBuffer);
        return Continue$.MODULE$;
    }

    private Error headerSizeError(int size, int streamId) {
        String msg = new StringBuilder(27).append("Stream(").append(FrameDecoder$.MODULE$.hexStr(streamId)).append(") sent too large of ").append(new StringBuilder(35).append("a header block. Received: ").append(size).append(". Limit: ").append(this.localSettings.maxHeaderListSize()).toString()).toString();
        return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(msg));
    }

    public class PHeaders
    implements PartialFrame,
    Product,
    Serializable {
        private final int streamId;
        private final Priority priority;
        private final boolean endStream;
        private ByteBuffer buffer;
        private final /* synthetic */ HeaderAggregatingFrameListener $outer;

        public PHeaders(HeaderAggregatingFrameListener $outer, int streamId, Priority priority, boolean endStream, ByteBuffer buffer) {
            this.streamId = streamId;
            this.priority = priority;
            this.endStream = endStream;
            this.buffer = buffer;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.streamId());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.priority()));
            n = Statics.mix((int)n, (int)(this.endStream() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.buffer()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PHeaders)) return false;
            if (((PHeaders)object).org$http4s$blaze$http$http2$HeaderAggregatingFrameListener$PHeaders$$$outer() != this.$outer) return false;
            PHeaders pHeaders = (PHeaders)object;
            if (this.streamId() != pHeaders.streamId()) return false;
            if (this.endStream() != pHeaders.endStream()) return false;
            Priority priority = this.priority();
            Priority priority2 = pHeaders.priority();
            if (priority == null) {
                if (priority2 != null) {
                    return false;
                }
            } else if (!priority.equals(priority2)) return false;
            ByteBuffer byteBuffer = this.buffer();
            ByteBuffer byteBuffer2 = pHeaders.buffer();
            if (byteBuffer == null) {
                if (byteBuffer2 != null) {
                    return false;
                }
            } else if (!((Object)byteBuffer).equals(byteBuffer2)) return false;
            if (!pHeaders.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PHeaders;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "PHeaders";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "streamId";
                }
                case 1: {
                    return "priority";
                }
                case 2: {
                    return "endStream";
                }
                case 3: {
                    return "buffer";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public int streamId() {
            return this.streamId;
        }

        public Priority priority() {
            return this.priority;
        }

        public boolean endStream() {
            return this.endStream;
        }

        @Override
        public ByteBuffer buffer() {
            return this.buffer;
        }

        @Override
        public void buffer_$eq(ByteBuffer x$1) {
            this.buffer = x$1;
        }

        public PHeaders copy(int streamId, Priority priority, boolean endStream, ByteBuffer buffer) {
            return new PHeaders(this.$outer, streamId, priority, endStream, buffer);
        }

        public int copy$default$1() {
            return this.streamId();
        }

        public Priority copy$default$2() {
            return this.priority();
        }

        public boolean copy$default$3() {
            return this.endStream();
        }

        public ByteBuffer copy$default$4() {
            return this.buffer();
        }

        public int _1() {
            return this.streamId();
        }

        public Priority _2() {
            return this.priority();
        }

        public boolean _3() {
            return this.endStream();
        }

        public ByteBuffer _4() {
            return this.buffer();
        }

        public final /* synthetic */ HeaderAggregatingFrameListener org$http4s$blaze$http$http2$HeaderAggregatingFrameListener$PHeaders$$$outer() {
            return this.$outer;
        }
    }

    public class PPromise
    implements PartialFrame,
    Product,
    Serializable {
        private final int streamId;
        private final int promisedId;
        private ByteBuffer buffer;
        private final /* synthetic */ HeaderAggregatingFrameListener $outer;

        public PPromise(HeaderAggregatingFrameListener $outer, int streamId, int promisedId, ByteBuffer buffer) {
            this.streamId = streamId;
            this.promisedId = promisedId;
            this.buffer = buffer;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.streamId());
            n = Statics.mix((int)n, (int)this.promisedId());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.buffer()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PPromise)) return false;
            if (((PPromise)object).org$http4s$blaze$http$http2$HeaderAggregatingFrameListener$PPromise$$$outer() != this.$outer) return false;
            PPromise pPromise = (PPromise)object;
            if (this.streamId() != pPromise.streamId()) return false;
            if (this.promisedId() != pPromise.promisedId()) return false;
            ByteBuffer byteBuffer = this.buffer();
            ByteBuffer byteBuffer2 = pPromise.buffer();
            if (byteBuffer == null) {
                if (byteBuffer2 != null) {
                    return false;
                }
            } else if (!((Object)byteBuffer).equals(byteBuffer2)) return false;
            if (!pPromise.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PPromise;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "PPromise";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "streamId";
                }
                case 1: {
                    return "promisedId";
                }
                case 2: {
                    return "buffer";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public int streamId() {
            return this.streamId;
        }

        public int promisedId() {
            return this.promisedId;
        }

        @Override
        public ByteBuffer buffer() {
            return this.buffer;
        }

        @Override
        public void buffer_$eq(ByteBuffer x$1) {
            this.buffer = x$1;
        }

        public PPromise copy(int streamId, int promisedId, ByteBuffer buffer) {
            return new PPromise(this.$outer, streamId, promisedId, buffer);
        }

        public int copy$default$1() {
            return this.streamId();
        }

        public int copy$default$2() {
            return this.promisedId();
        }

        public ByteBuffer copy$default$3() {
            return this.buffer();
        }

        public int _1() {
            return this.streamId();
        }

        public int _2() {
            return this.promisedId();
        }

        public ByteBuffer _3() {
            return this.buffer();
        }

        public final /* synthetic */ HeaderAggregatingFrameListener org$http4s$blaze$http$http2$HeaderAggregatingFrameListener$PPromise$$$outer() {
            return this.$outer;
        }
    }

    public interface PartialFrame {
        public int streamId();

        public ByteBuffer buffer();

        public void buffer_$eq(ByteBuffer var1);
    }
}

