/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.util;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URI;
import org.http4s.blaze.http.util.UrlTools$UrlComposition$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;

public final class UrlTools {

    public static class UrlComposition
    implements Product,
    Serializable {
        private final URI uri;
        private final String scheme;
        private final String authority;

        public static Try<UrlComposition> apply(String string) {
            return UrlTools$UrlComposition$.MODULE$.apply(string);
        }

        public static UrlComposition apply(URI uRI) {
            return UrlTools$UrlComposition$.MODULE$.apply(uRI);
        }

        public static UrlComposition fromProduct(Product product) {
            return UrlTools$UrlComposition$.MODULE$.fromProduct(product);
        }

        public static UrlComposition unapply(UrlComposition urlComposition) {
            return UrlTools$UrlComposition$.MODULE$.unapply(urlComposition);
        }

        public UrlComposition(URI uri) {
            this.uri = uri;
            this.scheme = uri.getScheme().toLowerCase();
            this.authority = uri.getAuthority().toLowerCase();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UrlComposition)) return false;
            UrlComposition urlComposition = (UrlComposition)object;
            URI uRI = this.uri();
            URI uRI2 = urlComposition.uri();
            if (uRI == null) {
                if (uRI2 != null) {
                    return false;
                }
            } else if (!((Object)uRI).equals(uRI2)) return false;
            if (!urlComposition.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UrlComposition;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "UrlComposition";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "uri";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public URI uri() {
            return this.uri;
        }

        public String scheme() {
            return this.scheme;
        }

        public String authority() {
            return this.authority;
        }

        public boolean isTls() {
            String string = this.scheme();
            String string2 = "https";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }

        public String path() {
            String string = this.uri().getPath();
            if ("".equals(string) || string == null) {
                return "/";
            }
            String p = string;
            return p;
        }

        public String fullPath() {
            if (this.uri().getQuery() != null) {
                return new StringBuilder(1).append(this.path()).append("?").append(this.uri().getQuery()).toString();
            }
            return this.path();
        }

        public InetSocketAddress getAddress() {
            int port = this.uri().getPort() > 0 ? this.uri().getPort() : (this.uri().getScheme().equalsIgnoreCase("http") ? 80 : 443);
            return new InetSocketAddress(this.uri().getHost(), port);
        }

        public UrlComposition copy(URI uri) {
            return new UrlComposition(uri);
        }

        public URI copy$default$1() {
            return this.uri();
        }

        public URI _1() {
            return this.uri();
        }
    }
}

