/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.util;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.http4s.blaze.http.HeaderNames$;
import org.http4s.blaze.http.util.HeaderLike;
import org.http4s.blaze.http.util.HeaderLike$;
import org.http4s.blaze.http.util.HeaderTools;
import org.http4s.blaze.http.util.HeaderTools$CachedDateHeader$;
import org.http4s.blaze.http.util.HeaderTools$SpecialHeaders$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.runtime.ModuleSerializationProxy;

public final class HeaderTools$
implements Serializable {
    private static final HeaderTools$CachedDateHeader$ CachedDateHeader;
    private static final DateTimeFormatter dateFormat;
    private static volatile HeaderTools.CachedDateHeader dateTime;
    public static final HeaderTools$SpecialHeaders$ SpecialHeaders;
    public static final HeaderTools$ MODULE$;

    private HeaderTools$() {
    }

    static {
        MODULE$ = new HeaderTools$();
        dateFormat = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz").withLocale(Locale.US).withZone(ZoneId.of("GMT"));
        dateTime = HeaderTools$CachedDateHeader$.MODULE$.apply(0L, "");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HeaderTools$.class);
    }

    private String getDateHeader() {
        HeaderTools.CachedDateHeader cached = dateTime;
        long current = System.currentTimeMillis();
        if (current - cached.acquired() <= 1000L) {
            return cached.header();
        }
        String next = new StringBuilder(8).append("date: ").append(dateFormat.format(Instant.now())).append("\r\n").toString();
        dateTime = HeaderTools$CachedDateHeader$.MODULE$.apply(current, next);
        return next;
    }

    public boolean isKeepAlive(Option<String> connectionHeader, int minorVersion) {
        Option<String> option = connectionHeader;
        if (option instanceof Some) {
            String headerValue = (String)((Some)option).value();
            if (headerValue.equalsIgnoreCase("keep-alive")) {
                return true;
            }
            if (headerValue.equalsIgnoreCase("close")) {
                return false;
            }
            return headerValue.equalsIgnoreCase("upgrade");
        }
        if (None$.MODULE$.equals(option)) {
            return minorVersion != 0;
        }
        throw new MatchError(option);
    }

    public <H> HeaderTools.SpecialHeaders renderHeaders(scala.collection.mutable.StringBuilder sb, Iterable<H> headers, HeaderLike<H> evidence$1) {
        None$ transferEncoding = None$.MODULE$;
        None$ contentLength = None$.MODULE$;
        None$ connection = None$.MODULE$;
        boolean hasDateheader = false;
        HeaderLike<H> hl = HeaderLike$.MODULE$.apply(evidence$1);
        for (Object header : headers) {
            String k = hl.getKey(header);
            String v = hl.getValue(header);
            if (k.equalsIgnoreCase(HeaderNames$.MODULE$.TransferEncoding())) {
                transferEncoding = Some$.MODULE$.apply((Object)v);
                continue;
            }
            if (k.equalsIgnoreCase(HeaderNames$.MODULE$.ContentLength())) {
                contentLength = Some$.MODULE$.apply((Object)v);
                continue;
            }
            if (k.equalsIgnoreCase(HeaderNames$.MODULE$.Connection())) {
                connection = Some$.MODULE$.apply((Object)v);
                continue;
            }
            if (!hasDateheader && k.equalsIgnoreCase(HeaderNames$.MODULE$.Date())) {
                hasDateheader = true;
            }
            sb.append(k);
            if (v.length() > 0) {
                sb.append(": ").append(v);
            }
            sb.append("\r\n");
        }
        if (!hasDateheader) {
            sb.append(this.getDateHeader());
        }
        return HeaderTools$SpecialHeaders$.MODULE$.apply((Option<String>)transferEncoding, (Option<String>)contentLength, (Option<String>)connection);
    }
}

