/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.parser;

import java.nio.ByteBuffer;
import org.http4s.blaze.http.parser.BaseExceptions;
import org.http4s.blaze.http.parser.BodyAndHeaderParser;
import org.http4s.blaze.http.parser.HttpTokens;

public abstract class Http1ServerParser
extends BodyAndHeaderParser {
    private final int maxRequestLineSize;
    private LineState lineState = LineState.START;
    private String method;
    private String path;

    public abstract boolean submitRequestLine(String var1, String var2, String var3, int var4, int var5);

    public final boolean requestLineComplete() {
        return this.lineState == LineState.END;
    }

    public final boolean isStart() {
        return this.lineState == LineState.START;
    }

    @Override
    public void reset() {
        super.reset();
        this.internalReset();
    }

    private void internalReset() {
        this.lineState = LineState.START;
    }

    @Override
    public void shutdownParser() {
        super.shutdownParser();
        this.lineState = LineState.END;
    }

    public Http1ServerParser(int n, int n2, int n3, int n4) {
        super(n3, n2, n4, false);
        this.maxRequestLineSize = n;
        this.internalReset();
    }

    public Http1ServerParser(int n, int n2, int n3) {
        this(n, n2, n3, Integer.MAX_VALUE);
    }

    public Http1ServerParser(int n) {
        this(2048, 40960, n);
    }

    public Http1ServerParser() {
        this(10240);
    }

    @Override
    public boolean mustNotHaveBody() {
        return !this.definedContentLength() && !this.isChunked();
    }

    protected final boolean parseRequestLine(ByteBuffer byteBuffer) throws BaseExceptions.InvalidState, BaseExceptions.BadMessage {
        switch (this.lineState) {
            case START: {
                this.lineState = LineState.METHOD;
                this.resetLimit(this.maxRequestLineSize);
            }
            case METHOD: {
                char c = this.next(byteBuffer, false);
                while ('A' <= c && c <= 'Z') {
                    this.putChar(c);
                    c = this.next(byteBuffer, false);
                }
                if (c == '\uffff') {
                    return false;
                }
                this.method = this.getString();
                this.clearBuffer();
                if (!HttpTokens.isWhiteSpace(c)) {
                    String string = this.method + c;
                    this.shutdownParser();
                    throw new BaseExceptions.BadMessage("Invalid request method: '" + string + "'");
                }
                this.lineState = LineState.SPACE1;
            }
            case SPACE1: {
                char c = this.next(byteBuffer, false);
                while (c == ' ' || c == '\t') {
                    c = this.next(byteBuffer, false);
                }
                if (c == '\uffff') {
                    return false;
                }
                this.putChar(c);
                this.lineState = LineState.PATH;
            }
            case PATH: {
                char c = this.next(byteBuffer, false);
                while (c != ' ' && c != '\t') {
                    if (c == '\uffff') {
                        return false;
                    }
                    this.putChar(c);
                    c = this.next(byteBuffer, false);
                }
                this.path = this.getString();
                this.clearBuffer();
                this.lineState = LineState.SPACE2;
            }
            case SPACE2: {
                char c = this.next(byteBuffer, false);
                while (c == ' ' || c == '\t') {
                    c = this.next(byteBuffer, false);
                }
                if (c == '\uffff') {
                    return false;
                }
                if (c != 'H') {
                    this.shutdownParser();
                    throw new BaseExceptions.BadMessage("Http version started with illegal character: " + c);
                }
                this.putChar(c);
                this.lineState = LineState.VERSION;
            }
            case VERSION: {
                String string;
                int n;
                int n2;
                char c = this.next(byteBuffer, false);
                while (c != '\n') {
                    if (c == '\uffff') {
                        return false;
                    }
                    this.putChar(c);
                    c = this.next(byteBuffer, false);
                }
                if (this.arrayMatches(HTTP11Bytes)) {
                    n2 = 1;
                    n = 1;
                    string = "http";
                } else if (this.arrayMatches(HTTPS11Bytes)) {
                    n2 = 1;
                    n = 1;
                    string = "https";
                } else if (this.arrayMatches(HTTP10Bytes)) {
                    n2 = 1;
                    n = 0;
                    string = "http";
                } else if (this.arrayMatches(HTTPS10Bytes)) {
                    n2 = 1;
                    n = 0;
                    string = "https";
                } else {
                    String string2 = "Bad HTTP version: " + this.getString();
                    this.clearBuffer();
                    this.shutdownParser();
                    throw new BaseExceptions.BadMessage(string2);
                }
                this.clearBuffer();
                this.lineState = LineState.END;
                return !this.submitRequestLine(this.method, this.path, string, n2, n);
            }
        }
        throw new BaseExceptions.InvalidState("Attempted to parse Request line when already complete. LineState: '" + (Object)((Object)this.lineState) + "'");
    }

    private static enum LineState {
        START,
        METHOD,
        SPACE1,
        PATH,
        SPACE2,
        VERSION,
        END;

    }
}

