/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko;

public class HTMLUnicodeEntitiesParser {
    public static final int STATE_START = 0;
    private static final int STATE_ENDS_WITH_SEMICOLON = -2;
    private static final int STATE_HEXADECIMAL_CHAR = -102;
    private static final int STATE_DECIMAL_CHAR = -104;
    private static final int STATE_HEXADECIMAL_START = -103;
    private static final int STATE_NUMERIC_CHAR_END_SEMICOLON_MISSING = -105;
    private static final int STATE_ABSENCE_OF_DIGITS_IN_NUMERIC_CHARACTER_REFERENCE = -106;
    private int state_ = 0;
    private int consumedCount_;
    private String match_;
    private int code_;
    private int matchLength_;

    public String getMatch() {
        return this.match_;
    }

    public int getMatchLength() {
        return this.matchLength_;
    }

    public int getRewindCount() {
        return this.consumedCount_ - this.matchLength_;
    }

    public boolean endsWithSemicolon() {
        return -2 == this.state_;
    }

    public void setMatchFromCode() {
        if (0 == this.code_ || this.code_ > 0x10FFFF) {
            this.match_ = "\ufffd";
            this.matchLength_ = this.consumedCount_;
            return;
        }
        if (Character.isSurrogate((char)this.code_)) {
            this.match_ = "\ufffd";
            return;
        }
        switch (this.code_) {
            case 128: {
                this.match_ = "\u20ac";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 130: {
                this.match_ = "\u201a";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 131: {
                this.match_ = "\u0192";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 132: {
                this.match_ = "\u201e";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 133: {
                this.match_ = "\u2026";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 134: {
                this.match_ = "\u2020";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 135: {
                this.match_ = "\u2021";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 136: {
                this.match_ = "\u02c6";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 137: {
                this.match_ = "\u2030";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 138: {
                this.match_ = "\u0160";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 139: {
                this.match_ = "\u2039";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 140: {
                this.match_ = "\u0152";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 142: {
                this.match_ = "\u017d";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 145: {
                this.match_ = "\u2018";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 146: {
                this.match_ = "\u2019";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 147: {
                this.match_ = "\u201c";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 148: {
                this.match_ = "\u201d";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 149: {
                this.match_ = "\u2022";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 150: {
                this.match_ = "\u2013";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 151: {
                this.match_ = "\u2014";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 152: {
                this.match_ = "\u20dc";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 153: {
                this.match_ = "\u2122";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 154: {
                this.match_ = "\u0161";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 155: {
                this.match_ = "\u203a";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 156: {
                this.match_ = "\u0153";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 158: {
                this.match_ = "\u017e";
                this.matchLength_ = this.consumedCount_;
                return;
            }
            case 159: {
                this.match_ = "\u0178";
                this.matchLength_ = this.consumedCount_;
                return;
            }
        }
        this.match_ = new String(Character.toChars(this.code_));
        this.matchLength_ = this.consumedCount_;
    }

    public boolean parseNumeric(int current) {
        ++this.consumedCount_;
        switch (this.state_) {
            case 0: {
                if (88 == current || 120 == current) {
                    this.state_ = -103;
                    this.code_ = 0;
                    return true;
                }
                if (48 > current || current > 57) break;
                this.state_ = -104;
                this.code_ = this.code_ * 10 + current - 48;
                return true;
            }
            case -103: {
                if (48 <= current && current <= 57) {
                    this.state_ = -102;
                    this.code_ = this.code_ * 16 + current - 48;
                    return true;
                }
                if (65 <= current && current <= 70) {
                    this.state_ = -102;
                    this.code_ = this.code_ * 16 + current - 55;
                    return true;
                }
                if (97 <= current && current <= 102) {
                    this.state_ = -102;
                    this.code_ = this.code_ * 16 + current - 87;
                    return true;
                }
                this.state_ = -106;
                break;
            }
            case -102: {
                if (48 <= current && current <= 57) {
                    this.code_ = this.code_ * 16 + current - 48;
                    return true;
                }
                if (65 <= current && current <= 70) {
                    this.code_ = this.code_ * 16 + current - 55;
                    return true;
                }
                if (97 <= current && current <= 102) {
                    this.code_ = this.code_ * 16 + current - 87;
                    return true;
                }
                if (59 == current) {
                    this.setMatchFromCode();
                    return false;
                }
                this.state_ = -105;
                this.setMatchFromCode();
                this.matchLength_ = this.consumedCount_ - 1;
                break;
            }
            case -104: {
                if (48 <= current && current <= 57) {
                    this.code_ = this.code_ * 10 + current - 48;
                    return true;
                }
                if (59 == current) {
                    this.setMatchFromCode();
                    return false;
                }
                this.state_ = -105;
                this.setMatchFromCode();
                this.matchLength_ = this.consumedCount_ - 1;
            }
        }
        return false;
    }
}

