/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.csp.value;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import org.htmlunit.csp.Constants;

public final class MediaType {
    private final String type_;
    private final String subtype_;

    private MediaType(String type, String subtype) {
        this.type_ = type;
        this.subtype_ = subtype;
    }

    public String getType() {
        return this.type_;
    }

    public String getSubtype() {
        return this.subtype_;
    }

    public static Optional<MediaType> parseMediaType(String value) {
        Matcher matcher = Constants.MEDIA_TYPE_PATTERN.matcher(value);
        if (matcher.find()) {
            String type = matcher.group("type").toLowerCase(Locale.ROOT);
            String subtype = matcher.group("subtype").toLowerCase(Locale.ROOT);
            return Optional.of(new MediaType(type, subtype));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaType mediaType = (MediaType)o;
        return this.type_.equals(mediaType.type_) && this.subtype_.equals(mediaType.subtype_);
    }

    public int hashCode() {
        return Objects.hash(this.type_, this.subtype_);
    }

    public String toString() {
        return this.type_ + "/" + this.subtype_;
    }
}

