/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.utils.time;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.hswebframework.utils.time.SmartDateFormatter;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;

public interface DateFormatter {
    public static final List<DateFormatter> supportFormatter = new ArrayList<SmartDateFormatter>(Arrays.asList(SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.MM, SmartDateFormatter.dd), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.MM, SmartDateFormatter.strike, SmartDateFormatter.dd), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.slash, SmartDateFormatter.MM, SmartDateFormatter.slash, SmartDateFormatter.dd), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.year_cn, SmartDateFormatter.MM, SmartDateFormatter.month_cn, SmartDateFormatter.dd, SmartDateFormatter.day_cn), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.MM, SmartDateFormatter.strike, SmartDateFormatter.dd, SmartDateFormatter.blankSpace, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.MM, SmartDateFormatter.strike, SmartDateFormatter.dd, SmartDateFormatter.blankSpace, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss, SmartDateFormatter.str("."), SmartDateFormatter.SSS), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.slash, SmartDateFormatter.MM, SmartDateFormatter.slash, SmartDateFormatter.dd, SmartDateFormatter.blankSpace, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.MM, SmartDateFormatter.dd, SmartDateFormatter.HH, SmartDateFormatter.mm, SmartDateFormatter.ss), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.year_cn, SmartDateFormatter.M, SmartDateFormatter.month_cn, SmartDateFormatter.d, SmartDateFormatter.day_cn), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.year_cn, SmartDateFormatter.MM, SmartDateFormatter.month_cn, SmartDateFormatter.d, SmartDateFormatter.day_cn), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.year_cn, SmartDateFormatter.M, SmartDateFormatter.month_cn, SmartDateFormatter.dd, SmartDateFormatter.day_cn), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.M, SmartDateFormatter.strike, SmartDateFormatter.d), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.MM, SmartDateFormatter.strike, SmartDateFormatter.d), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.M, SmartDateFormatter.strike, SmartDateFormatter.dd), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.slash, SmartDateFormatter.M, SmartDateFormatter.slash, SmartDateFormatter.d), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.slash, SmartDateFormatter.MM, SmartDateFormatter.slash, SmartDateFormatter.d), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.slash, SmartDateFormatter.M, SmartDateFormatter.slash, SmartDateFormatter.dd), SmartDateFormatter.of("yyyy-MM-dd HH:mm:ssZ", SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.MM, SmartDateFormatter.strike, SmartDateFormatter.dd, SmartDateFormatter.blankSpace, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss, SmartDateFormatter.plus, SmartDateFormatter.Z), SmartDateFormatter.of("yyyy-MM-dd HH:mm:ss.SSSZ", SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.MM, SmartDateFormatter.strike, SmartDateFormatter.dd, SmartDateFormatter.blankSpace, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss, SmartDateFormatter.str("."), SmartDateFormatter.SSS, SmartDateFormatter.plus, SmartDateFormatter.Z), SmartDateFormatter.of("yyyy-MM-dd HH:mm:ss.SSSXXX", SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.MM, SmartDateFormatter.strike, SmartDateFormatter.dd, SmartDateFormatter.blankSpace, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss, SmartDateFormatter.str("."), SmartDateFormatter.SSS, SmartDateFormatter.XXX), SmartDateFormatter.of("yyyy-MM-dd'T'HH:mm:ss", SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.MM, SmartDateFormatter.strike, SmartDateFormatter.dd, SmartDateFormatter.T, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss), SmartDateFormatter.of("yyyy-MM-dd'T'HH:mm:ssZ", SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.MM, SmartDateFormatter.strike, SmartDateFormatter.dd, SmartDateFormatter.T, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss, SmartDateFormatter.plus, SmartDateFormatter.Z), SmartDateFormatter.of("yyyy-MM-dd'T'HH:mm:ssXXX", SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.MM, SmartDateFormatter.strike, SmartDateFormatter.dd, SmartDateFormatter.T, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss, SmartDateFormatter.plus, SmartDateFormatter.XXX), SmartDateFormatter.of("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.MM, SmartDateFormatter.strike, SmartDateFormatter.dd, SmartDateFormatter.T, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss, SmartDateFormatter.str("."), SmartDateFormatter.SSS, SmartDateFormatter.str("Z")), SmartDateFormatter.of("yyyy-MM-dd'T'HH:mm:ss.SSS", SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.MM, SmartDateFormatter.strike, SmartDateFormatter.dd, SmartDateFormatter.T, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss, SmartDateFormatter.str("."), SmartDateFormatter.SSS), SmartDateFormatter.of("yyyy-MM-dd'T'HH:mm:ss.SSSSSS", SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.MM, SmartDateFormatter.strike, SmartDateFormatter.dd, SmartDateFormatter.T, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss, SmartDateFormatter.str("."), SmartDateFormatter.SSS, SmartDateFormatter.SSS), SmartDateFormatter.of("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS", SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.MM, SmartDateFormatter.strike, SmartDateFormatter.dd, SmartDateFormatter.T, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss, SmartDateFormatter.str("."), SmartDateFormatter.SSS, SmartDateFormatter.SSS, SmartDateFormatter.SSS), SmartDateFormatter.of("yyyy-MM-dd'T'HH:mm:ss.SSSZ", SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.MM, SmartDateFormatter.strike, SmartDateFormatter.dd, SmartDateFormatter.T, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss, SmartDateFormatter.str("."), SmartDateFormatter.SSS, SmartDateFormatter.plus, SmartDateFormatter.Z), SmartDateFormatter.of("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.MM, SmartDateFormatter.strike, SmartDateFormatter.dd, SmartDateFormatter.T, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss, SmartDateFormatter.str("."), SmartDateFormatter.SSS, SmartDateFormatter.XXX), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.year_cn, SmartDateFormatter.MM, SmartDateFormatter.month_cn, SmartDateFormatter.dd, SmartDateFormatter.day_cn, SmartDateFormatter.HH, SmartDateFormatter.hour_cn, SmartDateFormatter.mm, SmartDateFormatter.minute_cn, SmartDateFormatter.ss, SmartDateFormatter.second_cn), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.year_cn, SmartDateFormatter.MM, SmartDateFormatter.month_cn, SmartDateFormatter.dd, SmartDateFormatter.day_cn, SmartDateFormatter.blankSpace, SmartDateFormatter.HH, SmartDateFormatter.hour_cn, SmartDateFormatter.mm, SmartDateFormatter.minute_cn, SmartDateFormatter.ss, SmartDateFormatter.second_cn), SmartDateFormatter.of(SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.M, SmartDateFormatter.strike, SmartDateFormatter.dd, SmartDateFormatter.blankSpace, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.M, SmartDateFormatter.strike, SmartDateFormatter.d, SmartDateFormatter.blankSpace, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.MM, SmartDateFormatter.strike, SmartDateFormatter.d, SmartDateFormatter.blankSpace, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.M, SmartDateFormatter.strike, SmartDateFormatter.dd, SmartDateFormatter.blankSpace, SmartDateFormatter.H, SmartDateFormatter.colon, SmartDateFormatter.m, SmartDateFormatter.colon, SmartDateFormatter.s), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.M, SmartDateFormatter.strike, SmartDateFormatter.d, SmartDateFormatter.blankSpace, SmartDateFormatter.H, SmartDateFormatter.colon, SmartDateFormatter.m, SmartDateFormatter.colon, SmartDateFormatter.s), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.strike, SmartDateFormatter.MM, SmartDateFormatter.strike, SmartDateFormatter.d, SmartDateFormatter.blankSpace, SmartDateFormatter.H, SmartDateFormatter.colon, SmartDateFormatter.m, SmartDateFormatter.colon, SmartDateFormatter.s), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.slash, SmartDateFormatter.M, SmartDateFormatter.slash, SmartDateFormatter.dd, SmartDateFormatter.blankSpace, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.slash, SmartDateFormatter.M, SmartDateFormatter.slash, SmartDateFormatter.d, SmartDateFormatter.blankSpace, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.slash, SmartDateFormatter.MM, SmartDateFormatter.slash, SmartDateFormatter.d, SmartDateFormatter.blankSpace, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.slash, SmartDateFormatter.M, SmartDateFormatter.slash, SmartDateFormatter.dd, SmartDateFormatter.blankSpace, SmartDateFormatter.H, SmartDateFormatter.colon, SmartDateFormatter.m, SmartDateFormatter.colon, SmartDateFormatter.s), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.slash, SmartDateFormatter.M, SmartDateFormatter.slash, SmartDateFormatter.d, SmartDateFormatter.blankSpace, SmartDateFormatter.H, SmartDateFormatter.colon, SmartDateFormatter.m, SmartDateFormatter.colon, SmartDateFormatter.s), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.slash, SmartDateFormatter.MM, SmartDateFormatter.slash, SmartDateFormatter.d, SmartDateFormatter.blankSpace, SmartDateFormatter.H, SmartDateFormatter.colon, SmartDateFormatter.m, SmartDateFormatter.colon, SmartDateFormatter.s), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.MM, SmartDateFormatter.dd, SmartDateFormatter.blankSpace, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss), SmartDateFormatter.of(SmartDateFormatter.yyyy, SmartDateFormatter.MM, SmartDateFormatter.dd, SmartDateFormatter.blankSpace, SmartDateFormatter.HH, SmartDateFormatter.mm, SmartDateFormatter.ss), SmartDateFormatter.of("yyyy\u5e74 MM\u6708 dd\u65e5 EEE HH:mm:ss zzz", SmartDateFormatter.yyyy, SmartDateFormatter.year_cn, SmartDateFormatter.blankSpace, SmartDateFormatter.MM, SmartDateFormatter.month_cn, SmartDateFormatter.blankSpace, SmartDateFormatter.dd, SmartDateFormatter.day_cn, SmartDateFormatter.blankSpace, SmartDateFormatter.weeks3, SmartDateFormatter.blankSpace, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss, SmartDateFormatter.blankSpace, SmartDateFormatter.zzz).withLocal(Locale.CHINA), SmartDateFormatter.of("EEE MMM dd HH:mm:ss zzz yyyy", SmartDateFormatter.weeks3, SmartDateFormatter.blankSpace, SmartDateFormatter.month3, SmartDateFormatter.blankSpace, SmartDateFormatter.dd, SmartDateFormatter.blankSpace, SmartDateFormatter.HH, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss, SmartDateFormatter.blankSpace, SmartDateFormatter.zzz, SmartDateFormatter.blankSpace, SmartDateFormatter.yyyy).withLocal(Locale.ENGLISH), SmartDateFormatter.of("MMM dd, yyyy K:mm:ss a", SmartDateFormatter.month3, SmartDateFormatter.blankSpace, SmartDateFormatter.dd, SmartDateFormatter.str(","), SmartDateFormatter.blankSpace, SmartDateFormatter.yyyy, SmartDateFormatter.blankSpace, SmartDateFormatter.K, SmartDateFormatter.colon, SmartDateFormatter.mm, SmartDateFormatter.colon, SmartDateFormatter.ss, SmartDateFormatter.blankSpace, SmartDateFormatter.a).withLocal(Locale.ENGLISH)));

    public boolean support(String var1);

    public Date format(String var1);

    public LocalDateTime parse(String var1);

    public String toString(Date var1);

    public String toString(LocalDateTime var1);

    public String getPattern();

    public static Date fromString(String dateString) {
        DateFormatter formatter = DateFormatter.getFormatter(dateString);
        if (formatter != null) {
            return formatter.format(dateString);
        }
        return null;
    }

    public static Date fromString(String dateString, String pattern) {
        DateFormatter formatter = DateFormatter.getFormatter(dateString);
        if (formatter != null) {
            return formatter.format(dateString);
        }
        return DateTimeFormat.forPattern((String)pattern).parseDateTime(dateString).toDate();
    }

    public static String toString(LocalDateTime date, String format) {
        if (null == date) {
            return null;
        }
        for (DateFormatter formatter : supportFormatter) {
            if (!formatter.getPattern().equals(format)) continue;
            return formatter.toString(date);
        }
        return DateTimeFormatter.ofPattern(format).format(date);
    }

    public static String toString(Date date, String format) {
        if (null == date) {
            return null;
        }
        for (DateFormatter formatter : supportFormatter) {
            if (!formatter.getPattern().equals(format)) continue;
            return formatter.toString(date);
        }
        return new DateTime((Object)date).toString(format);
    }

    public static boolean isSupport(String dateString) {
        return DateFormatter.getFormatter(dateString) != null;
    }

    public static DateFormatter getFormatter(String dateString) {
        if (dateString == null || dateString.length() < 4) {
            return null;
        }
        for (DateFormatter formatter : supportFormatter) {
            if (!formatter.support(dateString)) continue;
            return formatter;
        }
        return null;
    }
}

