/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final Map<String, Pattern> PATTERN_CACHE = new ConcurrentHashMap<String, Pattern>();
    static final char CN_CHAR_START = '\u4e00';
    static final char CN_CHAR_END = '\u9fa5';

    public static final Pattern compileRegex(String regex) {
        Pattern pattern = PATTERN_CACHE.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            PATTERN_CACHE.put(regex, pattern);
        }
        return pattern;
    }

    public static String toLowerCaseFirstOne(String str) {
        if (Character.isLowerCase(str.charAt(0))) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String toUpperCaseFirstOne(String str) {
        if (Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static final String underScoreCase2CamelCase(String str) {
        if (!str.contains("_")) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        char[] chars = str.toCharArray();
        boolean hitUnderScore = false;
        sb.append(chars[0]);
        for (int i = 1; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '_') {
                hitUnderScore = true;
                continue;
            }
            if (hitUnderScore) {
                sb.append(Character.toUpperCase(c));
                hitUnderScore = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static final String camelCase2UnderScoreCase(String str) {
        StringBuilder sb = new StringBuilder();
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isUpperCase(c)) {
                sb.append("_").append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String throwable2String(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public static String concat(Object ... more) {
        return StringUtils.concatSpiltWith("", more);
    }

    public static String concatSpiltWith(String split, Object ... more) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < more.length; ++i) {
            if (i != 0) {
                buf.append(split);
            }
            buf.append(more[i]);
        }
        return buf.toString();
    }

    public static String toASCII(String str) {
        StringBuffer strBuf = new StringBuffer();
        byte[] bGBK = str.getBytes();
        for (int i = 0; i < bGBK.length; ++i) {
            strBuf.append(Integer.toHexString(bGBK[i] & 0xFF));
        }
        return strBuf.toString();
    }

    public static String toUnicode(String str) {
        StringBuffer strBuf = new StringBuffer();
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            strBuf.append("\\u").append(Integer.toHexString(chars[i]));
        }
        return strBuf.toString();
    }

    public static String toUnicodeString(char[] chars) {
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            strBuf.append("\\u").append(Integer.toHexString(chars[i]));
        }
        return strBuf.toString();
    }

    public static boolean containsChineseChar(String str) {
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] < '\u4e00' || chars[i] > '\u9fa5') continue;
            return true;
        }
        return false;
    }

    public static boolean isNullOrEmpty(Object obj) {
        return obj == null || "".equals(obj.toString());
    }

    public static boolean isNumber(Object obj) {
        if (obj instanceof Number) {
            return true;
        }
        return StringUtils.isInt(obj) || StringUtils.isDouble(obj);
    }

    public static String matcherFirst(String patternStr, String text) {
        Pattern pattern = StringUtils.compileRegex(patternStr);
        Matcher matcher = pattern.matcher(text);
        String group = null;
        if (matcher.find()) {
            group = matcher.group();
        }
        return group;
    }

    public static boolean isInt(Object obj) {
        if (StringUtils.isNullOrEmpty(obj)) {
            return false;
        }
        if (obj instanceof Integer) {
            return true;
        }
        return obj.toString().matches("[-+]?\\d+");
    }

    public static boolean isDouble(Object obj) {
        if (StringUtils.isNullOrEmpty(obj)) {
            return false;
        }
        if (obj instanceof Double || obj instanceof Float) {
            return true;
        }
        return StringUtils.compileRegex("[-+]?\\d+\\.\\d+").matcher(obj.toString()).matches();
    }

    public static boolean isBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return true;
        }
        String strVal = String.valueOf(obj);
        return "true".equalsIgnoreCase(strVal) || "false".equalsIgnoreCase(strVal);
    }

    public static boolean isTrue(Object obj) {
        return "true".equals(String.valueOf(obj));
    }

    public static boolean contains(Object[] arr, Object ... obj) {
        if (arr == null || obj == null || arr.length == 0) {
            return false;
        }
        return Arrays.asList(arr).containsAll(Arrays.asList(obj));
    }

    public static int toInt(Object object, int defaultValue) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (StringUtils.isInt(object)) {
            return Integer.parseInt(object.toString());
        }
        if (StringUtils.isDouble(object)) {
            return (int)Double.parseDouble(object.toString());
        }
        return defaultValue;
    }

    public static int toInt(Object object) {
        return StringUtils.toInt(object, 0);
    }

    public static long toLong(Object object, long defaultValue) {
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (StringUtils.isInt(object)) {
            return Long.parseLong(object.toString());
        }
        if (StringUtils.isDouble(object)) {
            return (long)Double.parseDouble(object.toString());
        }
        return defaultValue;
    }

    public static long toLong(Object object) {
        return StringUtils.toLong(object, 0L);
    }

    public static double toDouble(Object object, double defaultValue) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (StringUtils.isNumber(object)) {
            return Double.parseDouble(object.toString());
        }
        if (null == object) {
            return defaultValue;
        }
        return 0.0;
    }

    public static double toDouble(Object object) {
        return StringUtils.toDouble(object, 0.0);
    }

    public static String[] splitFirst(String str, String regex) {
        return str.split(regex, 2);
    }

    public static String toString(Object object) {
        return StringUtils.toString(object, null);
    }

    public static String toString(Object object, String defaultValue) {
        if (object == null) {
            return defaultValue;
        }
        return String.valueOf(object);
    }

    public static final String[] toStringAndSplit(Object object, String regex) {
        if (StringUtils.isNullOrEmpty(object)) {
            return null;
        }
        return String.valueOf(object).split(regex);
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static boolean isMessyCode(String strName) {
        Pattern p = Pattern.compile("\\s*|\t*|\r*|\n*");
        Matcher m = p.matcher(strName);
        String after = m.replaceAll("");
        String temp = after.replaceAll("\\p{P}", "");
        char[] ch = temp.trim().toCharArray();
        float chLength = 0.0f;
        float count = 0.0f;
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (Character.isLetterOrDigit(c)) continue;
            if (!StringUtils.isChinese(c)) {
                count += 1.0f;
            }
            chLength += 1.0f;
        }
        float result = count / chLength;
        return (double)result > 0.4;
    }
}

